<?php

namespace Motors_E_W\Widgets\Rental;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\WidgetBase;
use STM_E_W\Widgets\Controls\ContentControls\SelectControl;
use STM_E_W\Widgets\Controls\ContentControls\TextControl;

class RentalForm extends WidgetBase {
	use SelectControl;
	use TextControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );
		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( $this->get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery', 'elementor-frontend' ) );
	}
	public function get_script_depends() {
		return array(
			'stm_gmap',
			'stmselect2',
			'app-select2',
			'uniform',
			'uniform-init',
			'stmdatetimepicker',
			'app-datetime',
			$this->get_name(),
		);
	}

	public function get_style_depends() {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = 'motors-general-admin';
		$widget_styles[] = 'uniform';
		$widget_styles[] = 'uniform-init';
		$widget_styles[] = 'stmselect2';
		$widget_styles[] = 'app-select2';
		$widget_styles[] = 'stmdatetimepicker';
		return $widget_styles;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_RENTAL );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-rental-form';
	}

	public function get_title() {
		return esc_html__( 'Rental Form', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-form-horizontal eicons-motors';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'general', __( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_select(
			'form_style',
			array(
				'label'   => esc_html__( 'Form Style', 'motors-elementor-widgets' ),
				'options' => array(
					'style_1' => esc_html__( 'Filled', 'motors-elementor-widgets' ),
					'style_2' => esc_html__( 'Outlined', 'motors-elementor-widgets' ),
				),
				'default' => 'style_1',
			),
		);

		$this->stm_ew_add_select(
			'form_align',
			array(
				'label'     => esc_html__( 'Offices position', 'motors-elementor-widgets' ),
				'options'   => array(
					'text-right' => esc_html__( 'Right', 'motors-elementor-widgets' ),
					'text-left'  => esc_html__( 'Left', 'motors-elementor-widgets' ),
				),
				'default'   => 'text-right',
				'separator' => 'after',
			),
		);

		$this->stm_ew_add_text(
			'form_working_hours',
			array(
				'label'       => __( 'Set working hours', 'motors-elementor-widgets' ),
				'description' => __( 'Example: 9-18', 'motors-elementor-widgets' ),
			)
		);

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'widgets/rental/rental-form', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
