<?php

namespace Motors_E_W\Widgets\WidgetManager;

use Motors_E_W\Pro\Widgets\HeroBanner;
use Motors_E_W\Pro\Widgets\HeroSlider;
use Motors_E_W\Pro\Widgets\AddListing;
use Motors_E_W\Pro\Widgets\DealersList;
use Motors_E_W\Pro\Widgets\ListingsCompare;
use Motors_E_W\Pro\Widgets\ImageCategories;
use Motors_E_W\Pro\Widgets\ListingSearchTabs;
use Motors_E_W\Pro\Widgets\ListingsMap;
use Motors_E_W\Pro\Widgets\LoginRegister;
use Motors_E_W\Widgets\MegaMenu\TopCategories;
use Motors_E_W\Widgets\MegaMenu\TopMakesTabs;
use Motors_E_W\Widgets\MegaMenu\TopVehicles;
use Motors_E_W\Pro\Widgets\PostsGrid;
use Motors_E_W\Pro\Widgets\PricingPlan;
use Motors_E_W\Pro\Widgets\PlayVideo;
use Motors_E_W\Pro\Widgets\SingleListing\Actions;
use Motors_E_W\Pro\Widgets\SingleListing\CarGuru;
use Motors_E_W\Pro\Widgets\SingleListing\CarMPG;
use Motors_E_W\Pro\Widgets\SingleListing\ContactInfo;
use Motors_E_W\Pro\Widgets\SingleListing\DealerEmail;
use Motors_E_W\Pro\Widgets\SingleListing\DealerPhoneNumber;
use Motors_E_W\Pro\Widgets\SingleListing\Features;
use Motors_E_W\Pro\Widgets\SingleListing\Gallery;
use Motors_E_W\Pro\Widgets\SingleListing\GalleryMosaic;
use Motors_E_W\Pro\Widgets\SingleListing\GalleryCarousel;
use Motors_E_W\Pro\Widgets\SingleListing\GalleryCarouselMini;
use Motors_E_W\Pro\Widgets\SingleListing\ListingData;
use Motors_E_W\Pro\Widgets\SingleListing\Classified\ListingData as ListingDataClassified;
use Motors_E_W\Pro\Widgets\SingleListing\ListingMap;
use Motors_E_W\Pro\Widgets\SingleListing\ListingSellersNotes;
use Motors_E_W\Pro\Widgets\SingleListing\ListingSpecifications;
use Motors_E_W\Pro\Widgets\SingleListing\OfferPriceButton;
use Motors_E_W\Pro\Widgets\SingleListing\Price;
use Motors_E_W\Pro\Widgets\SingleListing\Classified\Price as PriceClassified;
use Motors_E_W\Pro\Widgets\SingleListing\SearchResults;
use Motors_E_W\Pro\Widgets\SingleListing\ListingDescription;
use Motors_E_W\Pro\Widgets\SingleListing\Similar;
use Motors_E_W\Pro\Widgets\SingleListing\Title;
use Motors_E_W\Pro\Widgets\SingleListing\Classified\Title as TitleClassified;
use Motors_E_W\Pro\Widgets\SingleListing\TradeInButton;
use Motors_E_W\Pro\Widgets\SingleListing\Classified\UserDataAdvanced;
use Motors_E_W\Pro\Widgets\SingleListing\Classified\UserDataSimple;
use Motors_E_W\Pro\Widgets\SingleListing\WhatsApp;
use Motors_E_W\Pro\Widgets\SingleListing\AttributeBoxes;
use Motors_E_W\Pro\Widgets\Info;
use Motors_E_W\Pro\Widgets\CarListingTabs;
use Motors_E_W\Pro\Widgets\LoanCalculator;
use Motors_E_W\Pro\Widgets\ContactTabs;
use Motors_E_W\Pro\Widgets\ListingsCarousel;
use Motors_E_W\Pro\Widgets\ListingsGrid;
use Motors_E_W\Pro\Widgets\ListingsGridTabs;
use Motors_E_W\Pro\Widgets\ListingsList;
use Motors_E_W\Pro\Widgets\ListingsCategoriesMasonry;
use Motors_E_W\Pro\Widgets\InventorySearchFilter;
use Motors_E_W\Pro\Widgets\InventorySearchResults;
use Motors_E_W\Pro\Widgets\InventorySortBy;
use Motors_E_W\Pro\Widgets\InventoryViewType;
use Motors_E_W\Pro\Widgets\ImageCarousel;
use Motors_E_W\Pro\Widgets\TestimonialsCarousel;
use Motors_E_W\Pro\Widgets\ArrowBanner;
use Motors_E_W\Pro\Widgets\SellYourCar;
use Motors_E_W\Widgets\MultiListing\MultiListingSearchTabs;
use Motors_E_W\Widgets\MultiListing\MultiListingsGridTabs;
use Motors_E_W\Widgets\MultiListing\MultiListingAddItemButtons;
use Motors_E_W\Widgets\Rental\RentalForm;
use Motors_E_W\Widgets\Rental\RentalProductGrid;
use Motors_E_W\Widgets\Rental\RentalOfficesMap;
use Motors_E_W\Widgets\Rental\RentalReservationSteps;
use Motors_E_W\Widgets\Rental\RentalReservationInfo;
use Motors_E_W\Widgets\Rental\RentalVehicleAddons;
use Motors_E_W\Widgets\Rental\RentalCoupon;
use Motors_E_W\Widgets\Rental\RentalCheckoutForm;
use STM_E_W\Helpers\Helper;


class MotorsWidgetsManager {

	private static $instance = array();

	protected function __construct() {
	}

	protected function __clone() {
	}

	public static function getInstance() {
		$cls = static::class;
		if ( ! isset( self::$instance[ $cls ] ) ) {
			self::$instance[ $cls ] = new static();
		}

		return self::$instance[ $cls ];
	}

	public function stm_ew_get_all_registered_widgets() {
		$widgets = array();
		if ( 'car_rental_elementor' === Helper::stm_ew_get_selected_layout() ) {
			$widgets = array(
				RentalForm::class,
				RentalProductGrid::class,
				RentalOfficesMap::class,
				RentalReservationSteps::class,
				RentalReservationInfo::class,
				RentalVehicleAddons::class,
				RentalCoupon::class,
				RentalCheckoutForm::class,
			);

			if ( ! apply_filters( 'is_mvl_pro', false ) ) {
				$widgets = array_merge(
					$widgets,
					array(
						HeroBanner::class,
						HeroSlider::class,
						ContactInfo::class,
						ImageCarousel::class,
						TestimonialsCarousel::class,
						ContactTabs::class,
						ArrowBanner::class,
						PostsGrid::class,
						PlayVideo::class,
					)
				);
			}
		} else {
			$widgets = array(
				HeroBanner::class,
				HeroSlider::class,
				LoanCalculator::class,
				CarListingTabs::class,
				ContactInfo::class,
				ListingsCompare::class,
				ListingsCarousel::class,
				ListingsGrid::class,
				ListingsGridTabs::class,
				ListingSearchTabs::class,
				ListingsList::class,
				ListingsCategoriesMasonry::class,
				InventorySearchResults::class,
				InventorySearchFilter::class,
				InventorySortBy::class,
				InventoryViewType::class,
				ImageCarousel::class,
				TestimonialsCarousel::class,
				Actions::class,
				CarGuru::class,
				CarMPG::class,
				DealerEmail::class,
				DealerPhoneNumber::class,
				Features::class,
				Gallery::class,
				GalleryMosaic::class,
				GalleryCarousel::class,
				GalleryCarouselMini::class,
				ListingData::class,
				ListingDataClassified::class,
				ListingSpecifications::class,
				Info::class,
				Price::class,
				PriceClassified::class,
				SearchResults::class,
				ListingDescription::class,
				ListingSellersNotes::class,
				Similar::class,
				ContactTabs::class,
				Title::class,
				TitleClassified::class,
				OfferPriceButton::class,
				TradeInButton::class,
				WhatsApp::class,
				AttributeBoxes::class,
				ArrowBanner::class,
				ImageCategories::class,
				PostsGrid::class,
				ListingMap::class,
				PlayVideo::class,
				SellYourCar::class,
			);
		}

		if ( 'listing_one_elementor' === Helper::stm_ew_get_selected_layout() || 'listing_two_elementor' === Helper::stm_ew_get_selected_layout() || 'listing_four_elementor' === Helper::stm_ew_get_selected_layout() || 'car_dealer_two_elementor' === Helper::stm_ew_get_selected_layout() || 'listing_three_elementor' === Helper::stm_ew_get_selected_layout() || 'listing_five_elementor' === Helper::stm_ew_get_selected_layout() ) {
			$widgets = array_merge(
				array(
					AddListing::class,
					UserDataAdvanced::class,
					UserDataSimple::class,
					PricingPlan::class,
					DealersList::class,
					LoginRegister::class,
					ListingsMap::class,
				),
				$widgets
			);
		}

		if ( Helper::is_multilisting_active() ) {
			$widgets = array_merge(
				array(
					MultiListingSearchTabs::class,
					MultiListingsGridTabs::class,
					MultiListingAddItemButtons::class,
				),
				$widgets
			);
		}

		if ( Helper::is_megamenu_active() ) {
			$widgets = array_merge(
				array(
					TopMakesTabs::class,
					TopCategories::class,
					TopVehicles::class,
				),
				$widgets
			);
		}

		return $widgets;
	}
}
