<?php
global $listing_id;

$listing_id = ( is_null( $listing_id ) ) ? get_the_ID() : $listing_id;

// Getting gallery list.
$gallery          = get_post_meta( $listing_id, 'gallery', true );
$video_preview    = get_post_meta( $listing_id, 'video_preview', true );
$gallery_video    = get_post_meta( $listing_id, 'gallery_video', true );
$sold             = get_post_meta( $listing_id, 'car_mark_as_sold', true );
$sold_badge_color = apply_filters( 'motors_vl_get_nuxy_mod', '', 'sold_badge_bg_color' );
$special_car      = get_post_meta( $listing_id, 'special_car', true );
$badge_text       = get_post_meta( $listing_id, 'badge_text', true );
$badge_bg_color   = get_post_meta( $listing_id, 'badge_bg_color', true );
$car_brochure     = get_post_meta( $listing_id, 'car_brochure', true );
$placeholder_path = 'plchldr350.png';
if ( empty( $badge_text ) ) {
	$badge_text = esc_html__( 'Featured Listing', 'motors-elementor-widgets' );
}

$badge_style = '';
if ( ! empty( $badge_bg_color ) ) {
	$badge_style = 'style=color:' . $badge_bg_color . ';';
}
?>

<div class="motors-elementor-single-listing-gallery-mosaic">

	<div class="stm-gallery-meta-top">

		<div class="stm-gallery-actions-box">
			<?php if ( 'yes' === $show_pdf && ! empty( $car_brochure ) ) : ?>
				<div class="stm-gallery-action-unit">
					<a href="<?php echo esc_url( wp_get_attachment_url( $car_brochure ) ); ?>" class="stm-brochure" title="<?php esc_html_e( 'Download brochure', 'motors-elementor-widgets' ); ?>" download>
						<i class="stm-icon-brochure"></i>
					</a>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_print ) : ?>
				<div class="stm-gallery-action-unit stm-listing-print-action">
					<a href="javascript:window.print()" class="car-action-unit stm-car-print">
						<i class="fas fa-print"></i>
					</a>
				</div>
			<?php endif; ?>
			<?php if ( apply_filters( 'is_listing', array() ) && ! empty( $show_featured ) && 'yes' === $show_featured ) : ?>
				<div class="stm-gallery-action-unit stm-listing-favorite-action" data-id="<?php echo esc_attr( $listing_id ); ?>">
					<i class="stm-service-icon-staricon"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_compare ) : ?>
				<div class="stm-gallery-action-unit compare" data-id="<?php echo esc_attr( $listing_id ); ?>" data-title="<?php echo wp_kses_post( apply_filters( 'stm_generate_title_from_slugs', get_the_title( $listing_id ), $listing_id ) ); ?>" data-post-type="<?php echo esc_attr( get_post_type( $listing_id ) ); ?>" data-placement="bottom">
					<i class="stm-service-icon-compare-new"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_test_drive ) : ?>
				<div class="stm-gallery-action-unit stm-schedule" data-toggle="modal" data-target="#test-drive" onclick="stm_test_drive_car_title(<?php echo esc_js( $listing_id ); ?>, '<?php echo esc_js( get_the_title( $listing_id ) ); ?>')">
					<i class="stm-icon-steering_wheel"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_share ) : ?>
				<div class="stm-gallery-action-unit">
					<i class="stm-icon-share"></i>
					<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) && ! get_post_meta( $listing_id, 'sharing_disabled', true ) ) : ?>
						<div class="stm-a2a-popup">
							<?php echo apply_filters( 'stm_add_to_any_shortcode', $listing_id ); //phpcs:ignore ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>

		<div class="stm-gallery-listing-info">

			<?php if ( empty( $sold ) && ! empty( $special_car ) && 'on' === $special_car ) : ?>

				<div class="stm-gallery-listing-info-item special-label-inline" <?php echo esc_attr( $badge_style ); ?>>
					<?php if ( ! empty( $featured_icon ) ) : ?>
						<i class="<?php echo esc_attr( $featured_icon['value'] ); ?>"></i>
					<?php endif; ?>
					<span class="label"><?php echo esc_html( apply_filters( 'stm_dynamic_string_translation', $badge_text, 'Special Badge Text' ) ); ?></span>
				</div>

			<?php elseif ( true === apply_filters( 'stm_sold_status_enabled', false ) && ! empty( $sold ) && ! empty( $show_sold_label ) ) : ?>

				<?php $badge_style = 'style=background-color:' . $sold_badge_color . ';color:#fff;font-size:20px;padding:4px;min-width:100px;justify-content:center;'; ?>
				<div class="stm-gallery-listing-info-item special-label-inline" <?php echo esc_attr( $badge_style ); ?>>
					<?php esc_html_e( 'Sold', 'motors-elementor-widgets' ); ?>
				</div>

			<?php endif; ?>

			<!--New badge with videos-->
			<?php $car_media = apply_filters( 'stm_get_car_medias', array(), $listing_id ); ?>
			<?php if ( ! empty( $car_media['car_videos_count'] ) && $car_media['car_videos_count'] > 0 ) : ?>

				<div class="stm-gallery-listing-info-item stm-car-videos stm-car-videos-<?php echo esc_attr( $listing_id ); ?>">
					<i class="fas fa-film"></i>
					<span><?php echo esc_html( $car_media['car_videos_count'] ); ?><?php esc_html_e( 'Video', 'motors-elementor-widgets' ); ?></span>
				</div>

				<?php // @codingStandardsIgnoreStart ?>
				<script>
					jQuery(document).ready(function () {
						jQuery(".stm-car-videos-<?php echo esc_js( $listing_id ); ?>").on('click', function () {
							jQuery(this).lightGallery({
								dynamic: true,
								dynamicEl: [
									<?php foreach ( $car_media['car_videos'] as $car_video ) : ?>
									{
										src: "<?php echo esc_url( $car_video ); ?>"
									},
									<?php endforeach; ?>
								],
								download: false,
								mode: 'lg-fade',
							})
						}); //click
					}); //ready
				</script>
				<?php // @codingStandardsIgnoreEnd ?>
			<?php endif; ?>

		</div>

	</div>

	<?php
	$gallery_to_show = array();

	if ( has_post_thumbnail( $listing_id ) ) {
		$src = wp_get_attachment_image_src( get_post_thumbnail_id( $listing_id ), 'stm-img-398-x-2' );

		if ( is_array( $src ) ) {
			$full_src = wp_get_attachment_image_src( get_post_thumbnail_id( $listing_id ), 'full' );
			$new_item = array(
				'image' => $src,
				'id'    => get_post_thumbnail_id( $listing_id ),
			);
			if ( is_array( $full_src ) ) {
				$new_item['link'] = $full_src[0];
			}
			$gallery_to_show[] = $new_item;
		}
	}

	if ( $include_video && ! empty( $video_preview ) && ! empty( $gallery_video ) ) {
		$src = wp_get_attachment_image_src( $video_preview, 'stm-img-398-x-2' );
		if ( is_array( $src ) ) {
			$gallery_to_show[] = array(
				'image'     => $src,
				'video_src' => $gallery_video,
				'id'        => $video_preview,
			);
		}
	} elseif ( ! empty( $gallery_video ) && empty( $video_preview ) ) {
		$src               = array();
		$src[]             = get_stylesheet_directory_uri() . '/assets/images/' . $placeholder_path;
		$gallery_to_show[] = array(
			'image'     => $src,
			'video_src' => $gallery_video,
			'id'        => 0,
		);

	}

	if ( ! empty( $gallery ) ) {

		foreach ( $gallery as $gallery_image ) {

			if ( get_post_thumbnail_id( $listing_id ) !== $gallery_image ) {

				$src = wp_get_attachment_image_src( $gallery_image, 'stm-img-398-x-2' );
				if ( is_array( $src ) ) {
					$full_src = wp_get_attachment_image_src( $gallery_image, 'full' );
					$new_item = array(
						'image' => $src,
						'id'    => $gallery_image,
					);
					if ( is_array( $full_src ) ) {
						$new_item['link'] = $full_src[0];
					}
					$gallery_to_show[] = $new_item;
				}
			}
		}
	}

	if ( ! empty( $gallery_to_show ) ) :
		$gallery_total  = count( $gallery_to_show );
		$gallery_layout = $gallery_total < 6 ? $gallery_total : 6;
		$more_label     = ( $gallery_total > 6 ) ? '+' . ( $gallery_total - 6 ) . ' more' : false;
		?>
		<div class="mosaic-gallery <?php echo esc_attr( 'items-' . $gallery_layout ); ?>">

			<?php if ( 6 === $gallery_layout ) : ?>

				<div class="wrapper-big">
					<div class="item item-big">
						<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<?php if ( ! empty( $gallery_to_show[1]['link'] ) ) : ?>
						<a href="<?php echo esc_url( $gallery_to_show[1]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<?php elseif ( ! empty( $gallery_to_show[1]['video_src'] ) ) : ?>
						<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[1]['video_src'] ); ?>">
						<?php else : ?>
						<a>
						<?php endif; ?>
							<img width="<?php echo esc_attr( $gallery_to_show[1]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[1]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[1]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[2]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[2]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[2]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[2]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
				</div>
				<div class="wrapper-small">
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[3]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[3]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[3]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[3]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[4]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[4]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[4]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[4]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[5]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[5]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[5]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[5]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
							<?php if ( $more_label ) : ?>
							<span class="more-label"><?php echo esc_html( $more_label ); ?></span>
							<?php endif; ?>
						</a>
					</div>
				</div>

				<?php if ( $gallery_total > 6 ) : ?>

					<div class="additional-images" style="display: none">
						<?php for ( $i = 6; $i < $gallery_total; $i++ ) : ?>
							<a href="<?php echo esc_url( $gallery_to_show[ $i ]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
								<img width="<?php echo esc_attr( $gallery_to_show[ $i ]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[ $i ]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[ $i ]['image'][0] ); ?>" alt="<?php the_title(); ?>">
							</a>
						<?php endfor; ?>
					</div>

				<?php endif; ?>

			<?php endif; ?>

			<?php if ( 5 === $gallery_layout ) : ?>

				<div class="item item-big">
					<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
				</div>
				<div class="wrapper-small">
					<div class="item item-small">
						<?php if ( ! empty( $gallery_to_show[1]['link'] ) ) : ?>
						<a href="<?php echo esc_url( $gallery_to_show[1]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<?php elseif ( ! empty( $gallery_to_show[1]['video_src'] ) ) : ?>
						<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[1]['video_src'] ); ?>">
						<?php else : ?>
						<a>
						<?php endif; ?>
							<img width="<?php echo esc_attr( $gallery_to_show[1]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[1]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[1]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[2]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[2]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[2]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[2]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[3]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[3]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[3]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[3]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[4]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[4]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[4]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[4]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
				</div>

			<?php endif; ?>

			<?php if ( 4 === $gallery_layout ) : ?>

				<div class="item item-big">
					<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
				</div>
				<div class="wrapper-small">
					<div class="item item-small">
						<?php if ( ! empty( $gallery_to_show[1]['link'] ) ) : ?>
						<a href="<?php echo esc_url( $gallery_to_show[1]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<?php elseif ( ! empty( $gallery_to_show[1]['video_src'] ) ) : ?>
						<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[1]['video_src'] ); ?>">
						<?php else : ?>
						<a>
							<?php endif; ?>
							<img width="<?php echo esc_attr( $gallery_to_show[1]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[1]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[1]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[2]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[2]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[2]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[2]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[3]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[3]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[3]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[3]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
				</div>

			<?php endif; ?>

			<?php if ( 3 === $gallery_layout ) : ?>

				<div class="item item-big">
					<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
				</div>
				<div class="wrapper-small">
					<div class="item item-small">
						<?php if ( ! empty( $gallery_to_show[1]['link'] ) ) : ?>
						<a href="<?php echo esc_url( $gallery_to_show[1]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<?php elseif ( ! empty( $gallery_to_show[1]['video_src'] ) ) : ?>
						<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[1]['video_src'] ); ?>">
						<?php else : ?>
						<a>
							<?php endif; ?>
							<img width="<?php echo esc_attr( $gallery_to_show[1]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[1]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[1]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
					<div class="item item-small">
						<a href="<?php echo esc_url( $gallery_to_show[2]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
							<img width="<?php echo esc_attr( $gallery_to_show[2]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[2]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[2]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
						</a>
					</div>
				</div>


			<?php endif; ?>

			<?php if ( 2 === $gallery_layout ) : ?>

				<div class="item item-big">
					<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
				</div>
				<div class="item item-big">
					<?php if ( ! empty( $gallery_to_show[1]['link'] ) ) : ?>
					<a href="<?php echo esc_url( $gallery_to_show[1]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
					<?php elseif ( ! empty( $gallery_to_show[1]['video_src'] ) ) : ?>
					<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[1]['video_src'] ); ?>">
					<?php else : ?>
					<a>
						<?php endif; ?>
						<img width="<?php echo esc_attr( $gallery_to_show[1]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[1]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[1]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
				</div>

			<?php endif; ?>

			<?php if ( 1 === $gallery_layout ) : ?>
				<div class="item item-big">
					<?php if ( ! empty( $gallery_to_show[0]['link'] ) ) : ?>
					<a href="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="stm_fancybox" target="_blank" rel="stm-gallery-mosaic">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['link'] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
					<?php elseif ( ! empty( $gallery_to_show[0]['video_src'] ) ) : ?>
					<a class="fancy-iframe video" data-iframe="true" data-src="<?php echo esc_url( $gallery_to_show[0]['video_src'] ); ?>">
						<img width="<?php echo esc_attr( $gallery_to_show[0]['image'][1] ); ?>" height="<?php echo esc_attr( $gallery_to_show[0]['image'][2] ); ?>" src="<?php echo esc_url( $gallery_to_show[0]['image'][0] ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
					</a>
					<?php endif; ?>
				</div>
			<?php endif; ?>

		</div>
	<?php else : ?>
	<div class="mosaic-gallery items-1">
		<div class="item item-big">
			<img src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/images/' . $placeholder_path ); ?>" class="img-responsive wp-post-image" alt="<?php the_title(); ?>">
		</div>
	</div>
	<?php endif; ?>

</div>
