<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


class CategoriesMultiListing extends STMMultiListing {
	public function __construct() {
		parent::__construct();
		$this->register_categories();

		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue' ) );
	}

	public function admin_enqueue( $hook_suffix ) {
		if ( 'motors-plugin_page_listing_categories' !== $hook_suffix ) {
			wp_dequeue_script( 'stm-listings-js' );
		}
	}

	public function register_categories() {
		if ( is_array( $this->listings ) && count( $this->listings ) ) {
			foreach ( $this->listings as $key => $listing ) {
				if ( empty( $listing['slug'] ) || empty( $listing['label'] ) ) {
					continue;
				}

				if ( post_type_exists( $listing['slug'] ) ) {
					continue;
				}

				$this->stm_create_post_type_category( $listing );

				add_action(
					'admin_menu',
					function () use ( $listing ) {
						$options      = get_option( "stm_{$listing['slug']}_options", array() );
						$options_list = array();
						if ( function_exists( 'stm_listings_page_options' ) ) {
							$options_list = stm_listings_page_options();
						}

						add_submenu_page(
							"edit.php?post_type={$listing['slug']}",
							/* translators: for menu MLT category  */
							sprintf( esc_html__( '%s Categories', 'motors_listing_types' ), $listing['label'] ),
							/* translators: for menu MLT category  */
							sprintf( esc_html__( '%s Categories', 'motors_listing_types' ), $listing['label'] ),
							'manage_options',
							"{$listing['slug']}_categories",
							function () use ( $listing, $options, $options_list ) {
								extract(//phpcs:ignore
									array(
										'listing'      => $listing,
										'options'      => $options,
										'options_list' => $options_list,
									)
								);

								if ( apply_filters( 'stm_is_listing_five', false ) ) {
									unset( $options_list['use_in_footer_search'] );
								}

								if ( defined( 'STM_LISTINGS_URL' ) ) {
									wp_enqueue_style( 'stm_admin_listing_categories-old', STM_LISTINGS_URL . '/assets/css/admin/categories-old.css', array(), MULTILISTING_V );
									wp_enqueue_script(
										'stm-listings-old',
										STM_LISTINGS_URL . '/assets/js/vehicles-listing-old.js',
										array(
											'jquery',
											'jquery-ui-droppable',
											'jquery-ui-datepicker',
											'jquery-ui-sortable',
										),
										MULTILISTING_V,
										true
									);
								}

								include_once MULTILISTING_PATH . '/templates/listing-category.php';
							}
						);
					}
				);

				add_action(
					"wp_ajax_stm_{$listing['slug']}_add_new_option",
					function () use ( $listing ) {
						if ( ! function_exists( 'stm_listings_reserved_terms' ) ) {
							return;
						}
						$data = array(
							'error'   => false,
							'message' => '',
						);

						$options = get_option( "stm_{$listing['slug']}_options", array() );

						/*Get reserved terms*/
						$reserved_terms = stm_listings_reserved_terms();

						$new_option = $_POST; // phpcs:ignore

						if ( empty( $new_option['slug'] ) && ! empty( $new_option['single_name'] ) ) {
							$new_option['slug'] = sanitize_title( $new_option['single_name'] );
						}

						if ( empty( $new_option['single_name'] ) || empty( $new_option['plural_name'] ) || empty( $new_option['slug'] ) ) {
							$data['error']   = true;
							$data['message'] = esc_html__(
								'Singular, Plural names and Slug are required',
								'motors_listing_types'
							);
						} else {
							$new_option['slug'] = sanitize_title( $new_option['slug'] );

							if ( in_array( $new_option['slug'], $reserved_terms, true ) || taxonomy_exists( $new_option['slug'] ) ) {
								$data['error']   = true;
								$data['message'] = esc_html__(
									'Slug name is already in use. Please choose another slug name.',
									'motors_listing_types'
								);
							}
						}

						if ( ! $data['error'] ) {
							$settings = stm_listings_page_options();

							foreach ( $settings as $setting_name => $setting ) {
								if ( ! empty( $new_option[ $setting_name ] ) ) {
									$current_option[ $setting_name ] =
										sanitize_text_field( $new_option[ $setting_name ] );
								} else {
									if ( strpos( $setting_name, 'divider' ) === false ) {
										$current_option[ $setting_name ] = '';
									}
								}
							}

							if ( empty( $current_option['listing_rows_numbers_enable'] ) ) {
								$current_option['enable_checkbox_button'] = '';
								$current_option['listing_rows_numbers']   = '';
							}

							$numeric = ( $new_option['numeric'] ) ? esc_html__( 'Yes', 'motors_listing_types' ) : esc_html__( 'No', 'motors_listing_types' );
							$link    = get_site_url() . '/wp-admin/edit-tags.php?taxonomy=' . esc_attr( $new_option['slug'] ) . "&post_type={$listing['slug']}";

							$options[] = $current_option;

							$data['option'] = array(
								'key'     => max( array_keys( $options ) ),
								'name'    => $new_option['single_name'],
								'plural'  => $new_option['plural_name'],
								'slug'    => $new_option['slug'],
								'numeric' => $numeric,
								'link'    => $link,
							);

							$this->stm_save_post_type_options( $listing, $options );
						}

						wp_send_json( $data );
						exit;
					}
				);

				add_action(
					"wp_ajax_stm_{$listing['slug']}_save_option_row",
					function () use ( $listing ) {
						$data = array(
							'error'   => false,
							'message' => '',
						);

						$options = get_option( "stm_{$listing['slug']}_options", array() );

						/*Check number of setting*/
						if ( ! isset( $_POST['stm_vehicle_listing_row_position'] ) ) { //phpcs:ignore
							$data['error']   = true;
							$data['message'] = esc_html__( 'Some error occurred 1', 'motors_listing_types' );
						} else {
							$option_key = intval( $_POST['stm_vehicle_listing_row_position'] ); // phpcs:ignore
						}

						/*Check if setting exists*/
						if ( empty( $options[ $option_key ] ) ) {
							$data['error']   = true;
							$data['message'] =
								esc_html__( 'Some error occurred 2', 'motors_listing_types' );
						} else {
							$current_option = $options[ $option_key ];
						}

						/*Check POST*/
						if ( empty( $_POST ) ) { // phpcs:ignore
							$data['error']   = true;
							$data['message'] =
								esc_html__( 'Some error occurred 3', 'motors_listing_types' );
						} else {
							$user_choice = $_POST; //phpcs:ignore
						}

						if ( ! $data['error'] ) {
							$settings = stm_listings_page_options();

							foreach ( $settings as $setting_name => $setting ) {
								if ( strpos( $setting_name, 'divider' ) === false ) {
									if ( ! empty( $user_choice[ $setting_name ] ) ) {
										$current_option[ $setting_name ] =
											( 'number_field_affix' === $setting_name )
												? esc_html( $user_choice[ $setting_name ] )
												: sanitize_text_field( $user_choice[ $setting_name ] );
									} else {
										$current_option[ $setting_name ] = '';
									}
								}
							}

							if ( empty( $current_option['listing_rows_numbers_enable'] ) ) {
								$current_option['enable_checkbox_button'] = '';
								$current_option['listing_rows_numbers']   = '';
							}

							$options[ $option_key ] = $current_option;

							$this->stm_save_post_type_options( $listing, $options );

							$data['error']   = false;
							$data['message'] = esc_html__( 'Settings saved', 'motors_listing_types' );
							$data['data']    = $current_option;
						}

						wp_send_json( $data );
						exit;
					}
				);

				add_action(
					"wp_ajax_stm_{$listing['slug']}_delete_option_row",
					function () use ( $listing ) {
						if ( isset( $_POST['number'] ) ) { //phpcs:ignore
							$options    = get_option( "stm_{$listing['slug']}_options", array() );
							$option_key = intval( $_POST['number'] ); //phpcs:ignore
							if ( ! empty( $options[ $option_key ] ) ) {
								unset( $options[ $option_key ] );
								$this->stm_save_post_type_options( $listing, $options );
							}
						}
						wp_send_json_success();
					}
				);

				add_action(
					"wp_ajax_stm_{$listing['slug']}_save_option_order",
					function () use ( $listing ) {
						if ( isset( $_POST['order'] ) ) { //phpcs:ignore
							$options     = get_option( "stm_{$listing['slug']}_options", array() );
							$new_options = explode( ',', sanitize_text_field( $_POST['order'] ) ); //phpcs:ignore
							$new_order   = array();
							foreach ( $new_options as $option ) {
								if ( ! empty( $options[ $option ] ) ) {
									$new_order[] = $options[ $option ];
								}
							}
							$this->stm_save_post_type_options( $listing, $new_order );
						}
						wp_send_json_success();
					}
				);

				$stm_get_car_parent_exist = $this->stm_get_car_parent_exists( $listing );

				if ( ! empty( $stm_get_car_parent_exist ) ) {
					foreach ( $stm_get_car_parent_exist as $stm_get_car_parent_exist_single ) {
						/** Add Custom Field To Form */
						add_action(
							$stm_get_car_parent_exist_single['slug'] . '_add_form_fields',
							function ( $taxonomy ) use ( $listing ) {
								set_query_var( 'listings_type', $listing['slug'] );
								HooksMultiListing::stm_listings_attributes_filter( $listing );
								$taxonomy             = apply_filters( 'stm_vl_get_all_by_slug', array(), $taxonomy );
								$taxonomy_parent_slug = $taxonomy['listing_taxonomy_parent'];
								$parents              = apply_filters( 'stm_get_category_by_slug_all', array(), $taxonomy_parent_slug, true );
								?>
								<div class="form-field">
									<label for="stm_parent_taxonomy">
										<?php esc_html_e( 'Choose parent taxonomy' ); ?>
									</label>
									<select multiple name="stm_parent_taxonomy[]" size="10">
										<option value=""><?php esc_html_e( 'No parent', 'motors_listing_types' ); ?></option>
										<?php if ( ! empty( $parents ) ) : ?>
											<?php foreach ( $parents as $term ) : ?>
												<option value="<?php echo esc_attr( $term->slug ); ?>">
													<?php
													echo esc_html( apply_filters( 'stm_parent_taxonomy_option', $term->name, $term, $taxonomy ) );
													?>
												</option>
											<?php endforeach; ?>
										<?php endif; ?>
									</select>
								</div>
								<?php
							},
							10
						);

						add_action(
							$stm_get_car_parent_exist_single['slug'] . '_edit_form_fields',
							function ( $tag, $taxonomy ) use ( $listing ) {
								set_query_var( 'listings_type', $listing['slug'] );
								HooksMultiListing::stm_listings_attributes_filter( $listing );
								$values               = get_term_meta( $tag->term_id, 'stm_parent' );
								$taxonomy             = apply_filters( 'stm_vl_get_all_by_slug', array(), $taxonomy );
								$taxonomy_parent_slug = $taxonomy['listing_taxonomy_parent'];
								$parents              = apply_filters( 'stm_get_category_by_slug_all', array(), $taxonomy_parent_slug, true );
								?>
								<tr class="form-field">
									<th scope="row" valign="top"><label
												for="stm_parent_taxonomy"><?php esc_html_e( 'Parent category' ); ?></label>
									</th>
									<td>
										<select multiple name="stm_parent_taxonomy[]" size="10">
											<option value=""><?php esc_html_e( 'No parent', 'motors_listing_types' ); ?></option>
											<?php if ( ! empty( $parents ) ) : ?>
												<?php foreach ( $parents as $term ) : ?>
													<option value="<?php echo esc_attr( $term->slug ); ?>" <?php selected( in_array( $term->slug, $values, true ) ); ?>>
														<?php echo esc_html( apply_filters( 'stm_parent_taxonomy_option', $term->name, $term, $taxonomy ) ); ?>
													</option>
												<?php endforeach; ?>
											<?php endif; ?>
										</select>
									</td>
								</tr>
								<?php
							},
							10,
							2
						);
						/** Save Custom Field Of Form */
						add_action(
							'created_' . $stm_get_car_parent_exist_single['slug'],
							'stm_taxonomy_listing_parent_save',
							10,
							2
						);
						add_action(
							'edited_' . $stm_get_car_parent_exist_single['slug'],
							'stm_taxonomy_listing_parent_save',
							10,
							2
						);
					}
				}
			}
		}
	}


	protected function stm_get_car_parent_exists( $listing ) {
		$car_listing = array();
		$options     = get_option( "stm_{$listing['slug']}_options", array() );
		if ( ! empty( $options ) ) {
			foreach ( $options as $key => $option ) {
				if ( ! empty( $option['listing_taxonomy_parent'] ) ) {
					$car_listing[] = $option;
				}
			}
		}

		return $car_listing;
	}

	protected function stm_create_post_type_category( $listing ) {
		$options = get_option( "stm_{$listing['slug']}_options" );
		if ( ! empty( $options ) ) {
			foreach ( $options as $option ) {
				$show_admin_table = false;
				if ( ! empty( $option['show_in_admin_column'] ) && $option['show_in_admin_column'] ) {
					$show_admin_table = true;
				}

				if ( empty( $option['numeric'] ) ) {
					$numeric = true;
				} else {
					$numeric          = false;
					$show_admin_table = false;
				}

				register_taxonomy(
					$option['slug'],
					$listing['slug'],
					array(
						'labels'             => array(
							'name'                       => $option['plural_name'],
							'singular_name'              => $option['single_name'],
							'search_items'               => sprintf( __( 'Search %s', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'popular_items'              => sprintf( __( 'Popular %s', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'all_items'                  => sprintf( __( 'All %s', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'parent_item'                => null,
							'parent_item_colon'          => null,
							'edit_item'                  => sprintf( __( 'Edit %s', 'motors_listing_types' ), $option['single_name'] ), //phpcs:ignore
							'update_item'                => sprintf( __( 'Update %s', 'motors_listing_types' ), $option['single_name'] ), //phpcs:ignore
							'add_new_item'               => sprintf( __( 'Add New %s', 'motors_listing_types' ), $option['single_name'] ), //phpcs:ignore
							'new_item_name'              => sprintf( __( 'New %s Name', 'motors_listing_types' ), $option['single_name'] ), //phpcs:ignore
							'separate_items_with_commas' => sprintf( __( 'Separate %s with commas', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'add_or_remove_items'        => sprintf( __( 'Add or remove %s', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'choose_from_most_used'      => sprintf( __( 'Choose from the most used %s', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'not_found'                  => sprintf( __( 'No %s found.', 'motors_listing_types' ), $option['plural_name'] ), //phpcs:ignore
							'menu_name'                  => $option['plural_name'],
						),
						'public'             => true,
						'hierarchical'       => $numeric,
						'show_ui'            => true,
						'show_in_menu'       => false,
						'show_admin_column'  => $show_admin_table,
						'show_in_nav_menus'  => false,
						'show_in_quick_edit' => false,
						'query_var'          => false,
						'rewrite'            => false,
						'meta_box_cb'        => false,
					)
				);
			};
		}
	}

	public static function stm_get_taxes_by_listing( $listing ) {
		$options[] = __( 'No parent' );
		if ( ! empty( $listing['slug'] ) ) {
			$temp = get_object_taxonomies( $listing['slug'], 'objects' );
			if ( ! empty( $temp ) ) {
				foreach ( $temp as $item ) {
					$labels                 = $item->labels;
					$options[ $item->name ] = $labels->singular_name;
				}
			}
		}

		return $options;
	}

}

new CategoriesMultiListing();
