<?php
//phpcs:disable
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class MetaboxMultiListing extends STMMultiListing
{
	public function __construct()
	{
		parent::__construct();
		add_action('plugins_loaded', array($this, 'register_metabox'));
	}

	public function register_metabox() {
		if( !class_exists('STM_PostType') ) return;

		$args = array(
			'fields' => array(
				'page_bg_color' => array(
					'label' => __( 'Page Background Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
				'transparent_header' => array(
					'label'   => __( 'Transparent Header', 'motors_listing_types' ),
					'type'    => 'checkbox'
				),
				'separator_title_box' => array(
					'label'   => __( 'Title Box', 'motors_listing_types' ),
					'type'    => 'separator'
				),
				'alignment' => array(
					'label'   => __( 'Alignment', 'motors_listing_types' ),
					'type'    => 'select',
					'options' => array(
						'left' => __( 'Left', 'motors_listing_types' ),
						'center' => __( 'Center', 'motors_listing_types' ),
						'right' => __( 'Right', 'motors_listing_types' )
					)
				),
				'title' => array(
					'label'   => __( 'Title', 'motors_listing_types' ),
					'type'    => 'select',
					'options' => array(
						'show' => __( 'Show', 'motors_listing_types' ),
						'hide' => __( 'Hide', 'motors_listing_types' )
					)
				),
				'sub_title' => array(
					'label'   => __( 'Sub Title', 'motors_listing_types' ),
					'type'    => 'text'
				),
				'title_box_bg_color' => array(
					'label' => __( 'Background Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
				'title_box_font_color' => array(
					'label' => __( 'Font Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
				'title_box_line_color' => array(
					'label' => __( 'Line Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
				'title_box_subtitle_font_color' => array(
					'label' => __( 'Sub Title Font Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
				'title_box_custom_bg_image' => array(
					'label' => __( 'Custom Background Image', 'motors_listing_types' ),
					'type'  => 'image'
				),
				'separator_breadcrumbs' => array(
					'label'   => __( 'Breadcrumbs', 'motors_listing_types' ),
					'type'    => 'separator'
				),
				'breadcrumbs' => array(
					'label'   => __( 'Breadcrumbs', 'motors_listing_types' ),
					'type'    => 'select',
					'options' => array(
						'show' => __( 'Show', 'motors_listing_types' ),
						'hide' => __( 'Hide', 'motors_listing_types' )
					)
				),
				'breadcrumbs_font_color' => array(
					'label' => __( 'Breadcrumbs Color', 'motors_listing_types' ),
					'type'  => 'color_picker'
				),
			)
		);

		STM_PostType::addMetaBox(
			'listing_seller_note',
			esc_html__( "Seller's note", 'motors_listing_types' ),
			$this->stm_get_listing_type_slugs(),
			'',
			'normal',
			'high',
			array(
				'fields' => array(
					'listing_seller_note' => array(
						'label' => '',
						'type'  => 'texteditor',
						'class' => 'fullwidth listing_seller_note'
					)
				)
			)
		);

		STM_PostType::addMetaBox(
			'page_options', __( 'Page Options', 'motors_listing_types' ),
			$this->stm_get_listing_type_slugs(),
			'',
			'',
			'',
			apply_filters('stm_multilisting_metabox', $args)
		);
	}
}

new MetaboxMultiListing;
//phpcs:enable