<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

function stm_listings_page_options() {
	$group_1 = array(
		'single_name' => array(
			'label' => esc_html__( 'Singular name', 'motors_listing_types' ),
			'value' => '',
			'type'  => 'text',
		),
		'plural_name' => array(
			'label' => esc_html__( 'Plural name', 'motors_listing_types' ),
			'value' => '',
			'type'  => 'text',
		),
		'slug'        => array(
			'label'       => esc_html__( 'Slug', 'motors_listing_types' ),
			'description' => esc_html__( 'Caution, you will not be able to change the link later', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'text',
		),
		'font'        => array(
			'label' => esc_html__( 'Choose icon', 'motors_listing_types' ),
			'value' => '',
			'type'  => 'icon',
		),
	);

	$group_1 = apply_filters( 'stm_listings_page_options_group_1', $group_1 );

	$group_1['divider_1'] = array( 'type' => 'divider' );

	$group_2 = array(
		'required_filed'                  => array(
			'label' => esc_html__( 'Required', 'motors_listing_types' ),
			'value' => '',
			'type'  => 'checkbox',
		),
		'numeric'                         => array(
			'label'       => esc_html__( 'Number field', 'motors_listing_types' ),
			'description' => esc_html__( 'Numeric value will be compared in another way (useful for mileage or fuel economy)', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'number_field_affix'              => array(
			'label'       => '',
			'description' => esc_html__( 'This affix will be shown after number. Example: mi, pcs, etc.', 'motors_listing_types' ),
			'value'       => '',
			'dependency'  => array(
				'slug' => 'numeric',
				'type' => 'not_empty',
			),
			'attributes'  => array(
				'placeholder' => esc_html__( 'Number field affix', 'motors_listing_types' ),
			),
			'type'        => 'text',
		),
		'slider_in_tabs'                  => array(
			'label'       => esc_html__( 'Display field as slider in tabs', 'motors_listing_types' ),
			'description' => esc_html__( 'Only for number field', 'motors_listing_types' ),
			'dependency'  => array(
				'slug' => 'numeric',
				'type' => 'not_empty',
			),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'slider'                          => array(
			'label'       => esc_html__( 'Display field as slider (Only classic filter)', 'motors_listing_types' ),
			'description' => esc_html__( 'Only for number field', 'motors_listing_types' ),
			'dependency'  => array(
				'slug' => 'numeric',
				'type' => 'not_empty',
			),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'slider_step'                     => array(
			'label'       => esc_html__( 'Slider step', 'motors_listing_types' ),
			'description' => '',
			'dependency'  => array(
				array(
					'slug' => 'numeric',
					'type' => 'not_empty',
				),
				array(
					'slug' => 'slider',
					'type' => 'not_empty',
				),
			),
			'value'       => 1,
			'attributes'  => array(
				'placeholder' => esc_html__( 'Enter step number', 'motors_listing_types' ),
			),
			'type'        => 'text',
		),
		'show_inputs'                     => array(
			'label'      => esc_html__( 'Show Inputs', 'motors_listing_types' ),
			'dependency' => array(
				'slug' => 'slider',
				'type' => 'not_empty',
			),
			'type'       => 'checkbox',
			'value'      => true,
		),
		'use_delimiter'                   => array(
			'label'      => esc_html__( 'Add delimiter', 'motors_listing_types' ),
			'dependency' => array(
				'slug' => 'numeric',
				'type' => 'not_empty',
			),
			'value'      => '',
			'type'       => 'checkbox',
		),
		'listing_price_field'             => array(
			'label'       => esc_html__( 'Listing price field', 'motors_listing_types' ),
			'description' => esc_html__( 'This field will be determined as the price for listings. Only one field can be assigned as price field!', 'motors_listing_types' ),
			'dependency'  => array(
				'slug' => 'numeric',
				'type' => 'not_empty',
			),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'use_on_car_listing_page'         => array(
			'label'       => esc_html__( 'Use on item grid view', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category on car listing page (machine card)', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'grid.jpg',
			'type'        => 'checkbox',
		),
		'use_on_car_archive_listing_page' => array(
			'label'       => esc_html__( 'Use on item list view', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category on car listing archive page with icon', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'list.jpg',
			'type'        => 'checkbox',
		),
		'use_on_single_car_page'          => array(
			'label'       => esc_html__( 'Use on single car page', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category on single car page', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'single_car_page.jpg',
			'type'        => 'checkbox',
		),
		'use_on_car_filter'               => array(
			'label'       => esc_html__( 'Use on car filter', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category in filter', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
		),
	);

	$group_2 = apply_filters( 'stm_listings_page_options_group_2', $group_2 );

	$group_2['divider_2'] = array( 'type' => 'divider' );

	$group_3 = array(
		'is_multiple_select'                   => array(
			'label'       => esc_html__( 'Multiple select for filter', 'motors_listing_types' ),
			'description' => esc_html__( 'Check to make select multiple on filter page', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'use_on_car_modern_filter_view_images' => array(
			'label'       => esc_html__( 'Use images for this category', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category with images', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'use_on_car_filter_links'              => array(
			'label'       => esc_html__( 'Use on car filter as block with links', 'motors_listing_types' ),
			'description' => esc_html__( 'Be aware of using both as filter option', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'car-filter-as-block-with-links.jpg',
			'type'        => 'checkbox',
		),
		'filter_links_default_expanded'        => array(
			'label'       => esc_html__( 'Use on car filter as block with links', 'motors_listing_types' ),
			'description' => esc_html__( 'Be aware of using both as filter option', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'radio',
			'dependency'  => array(
				'slug' => 'use_on_car_filter_links',
				'type' => 'not_empty',
			),
			'choices'     => array(
				'open'  => esc_html__( 'Open box by default', 'motors_listing_types' ),
				'close' => esc_html__( 'Close box by default', 'motors_listing_types' ),
			),
		),
	);

	$group_3 = apply_filters( 'stm_listings_page_options_group_3', $group_3 );

	$group_3['divider_3'] = array( 'type' => 'divider' );

	$group_4 = array(
		'use_on_directory_filter_title'         => array(
			'label'       => esc_html__( 'Use this category in generated Listing Filter title', 'motors_listing_types' ),
			'description' => esc_html__( 'Enable this field, if you want to include category in Listing Filter title.', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'title.jpg',
			'type'        => 'checkbox',
		),
		'use_on_single_listing_page'            => array(
			'label'       => esc_html__( 'Use on single listing page', 'motors_listing_types' ),
			'description' => esc_html__( 'Check if you want to see this category on single page', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
		),
		'listing_taxonomy_parent'               => array(
			'label'   => esc_html__( 'Set parent taxonomy', 'motors_listing_types' ),
			'value'   => '',
			'type'    => 'select',
			'choices' => stm_listings_parent_choice(),
		),
		'terms_filters_sort_by'                 => array(
			'label'   => esc_html__( 'Sort by filters', 'motors_listing_types' ),
			'value'   => 'count_asc',
			'type'    => 'select',
			'choices' => array(
				'count_asc'  => esc_html__( 'Count ASC', 'motors_listing_types' ),
				'count_desc' => esc_html__( 'Count DESC', 'motors_listing_types' ),
				'name_asc'   => esc_html__( 'Name ASC', 'motors_listing_types' ),
				'name_desc'  => esc_html__( 'Name DESC', 'motors_listing_types' ),
			),
		),
		'listing_rows_numbers_enable'           => array(
			'label'       => esc_html__( 'Use on listing archive as checkboxes', 'motors_listing_types' ),
			'description' => esc_html__( 'Use as checkboxes with images 1 or 2 columns', 'motors_listing_types' ),
			'value'       => '',
			'preview'     => 'column.png',
			'type'        => 'checkbox',
		),
		'listing_rows_numbers'                  => array(
			'label'       => esc_html__( 'Use on listing archive as checkboxes', 'motors_listing_types' ),
			'description' => esc_html__( 'Use as checkboxes with images 1 or 2 columns', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'radio',
			'dependency'  => array(
				'slug' => 'listing_rows_numbers_enable',
				'type' => 'not_empty',
			),
			'choices'     => array(
				'one_col'  => esc_html__( 'Use as 1 column per row', 'motors_listing_types' ),
				'two_cols' => esc_html__( 'Use as 2 columns per row', 'motors_listing_types' ),
			),
		),
		'enable_checkbox_button'                => array(
			'label'       => esc_html__( 'Add submit button to this checkbox area', 'motors_listing_types' ),
			'description' => esc_html__( 'AJAX filter will be triggered after clicking on button', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
			'dependency'  => array(
				'slug' => 'listing_rows_numbers_enable',
				'type' => 'not_empty',
			),
		),
		'listing_rows_numbers_default_expanded' => array(
			'label'      => esc_html__( 'Use on listing archive as checkboxes', 'motors_listing_types' ),
			'value'      => '',
			'type'       => 'radio',
			'dependency' => array(
				'slug' => 'listing_rows_numbers_enable',
				'type' => 'not_empty',
			),
			'choices'    => array(
				'open'  => esc_html__( 'Open box by default', 'motors_listing_types' ),
				'close' => esc_html__( 'Close box by default', 'motors_listing_types' ),
			),
		),
		'show_in_admin_column'                  => array(
			'label'       => esc_html__( 'Show in admin column table', 'motors_listing_types' ),
			'description' => esc_html__( 'This column will be shown in admin', 'motors_listing_types' ),
			'value'       => '',
			'type'        => 'checkbox',
			'preview'     => 'admin_table.png',
		),
	);

	$group_4 = apply_filters( 'stm_listings_page_options_group_4', $group_4 );

	$options = array_merge( $group_1, $group_2, $group_3, $group_4 );

	// remove "Listing price field" if multilisting is deactivated OR current post type is the default one
	if ( ! stm_is_multilisting() || ( isset( $_GET['post_type'] ) && apply_filters( 'stm_listings_post_type', 'listings' ) === $_GET['post_type'] ) ) {
		unset( $options['listing_price_field'] );
	}

	// rename all "car"s to "listing"s if multilisting is active
	if ( stm_is_multilisting() || ( isset( $_GET['post_type'] ) && apply_filters( 'stm_listings_post_type', 'listings' ) !== $_GET['post_type'] ) ) {
		foreach ( $options as $slug => $arr ) {
			if ( ! empty( $arr['label'] ) && strpos( $arr['label'], 'car' ) !== false ) {
				$options[ $slug ]['label'] = esc_html( str_replace( 'car', 'listing', $arr['label'] ) );
			} elseif ( ! empty( $arr['description'] ) && strpos( $arr['description'], 'car' ) !== false ) {
				$options[ $slug ]['description'] = esc_html( str_replace( 'car', 'listing', $arr['description'] ) );
			}
		}
	}

	return apply_filters( 'stm_listings_page_options_filter', $options );
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_text to get the html of the text field
 * @param $name
 * @param $settings
 * @param $values
 *
 * @return void
 */
function stm_vehicle_listings_field_text( $name, $settings, $values ) {
	$value      = ( ! empty( $values[ $name ] ) ) ? $values[ $name ] : '';
	$atts       = ( ! empty( $settings['attributes'] ) ) ? $settings['attributes'] : array();
	$input_atts = '';
	if ( ! empty( $atts ) ) {
		foreach ( $atts as $key => $att ) {
			$input_atts .= $key . '="' . esc_attr( $att ) . '" ';
		}
	}
	?>
	<div class="stm_form_wrapper stm_form_wrapper_<?php echo esc_attr( $settings['type'] ); ?> stm_form_wrapper_<?php echo esc_attr( $name ); ?> <?php echo esc_attr( stm_vehicles_listing_has_preview( $settings ) ); ?>" <?php stm_vehicles_listing_show_dependency( $settings ); ?>>
		<label>
			<span><?php echo esc_html( $settings['label'] ); ?></span>
			<input <?php echo wp_kses_post( apply_filters( 'stm_vl_atts_filter', $input_atts ) ); ?> type="<?php echo esc_attr( $settings['type'] ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" />
		</label>
		<?php stm_vehicles_listings_preview( $settings ); ?>
	</div>
	<?php
}

function stm_vehicles_listings_show_field( $name, $settings, $values ) {
	$type = 'stm_vehicle_listings_field_text';
	if ( ! empty( $settings['type'] ) ) {
		$type = 'stm_vehicle_listings_field_' . $settings['type'];
	}

	call_user_func( $type, $name, $settings, $values );
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_select to get the html of the select field
 * @param $name
 * @param $settings
 * @param $values
 *
 * @return void
 */
function stm_vehicle_listings_field_select( $name, $settings, $values ) {
	?>
	<div class="stm_form_wrapper stm_form_wrapper_<?php echo esc_attr( $settings['type'] ); ?>" <?php stm_vehicles_listing_show_dependency( $settings ); ?>>
		<span><?php echo esc_html( $settings['label'] ); ?></span>
		<select name="<?php echo esc_attr( $name ); ?>">
			<?php
			foreach ( $settings['choices'] as $value => $label ) :
				$selected = ( ! empty( $values[ $name ] ) && $values[ $name ] === $value ) ? 'selected' : '';
				?>
				<option value="<?php echo esc_attr( $value ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $label ); ?></option>
			<?php endforeach; ?>
		</select>
	</div>
	<?php
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_radio to get the html of the radio field
 * @param $name
 * @param $settings
 * @param $values
 *
 * @return void
 */
function stm_vehicle_listings_field_radio( $name, $settings, $values ) {
	if ( empty( $values[ $name ] ) ) {
		$first_key       = array_keys( $settings['choices'] );
		$values[ $name ] = $first_key[0];
	}
	?>
	<div class="stm_form_wrapper stm_form_wrapper_<?php echo esc_attr( $settings['type'] ); ?>" <?php stm_vehicles_listing_show_dependency( $settings ); ?>>
		<?php foreach ( $settings['choices'] as $value => $label ) : ?>
			<label>
				<input type="radio" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" <?php checked( $values[ $name ], $value ); ?> />
				<span><?php echo esc_html( $label ); ?></span>
			</label>
		<?php endforeach; ?>
	</div>
	<?php
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_checkbox to get the html of the checkbox field
 * @param $name
 * @param $settings
 * @param $values
 *
 * @return void
 */
function stm_vehicle_listings_field_checkbox( $name, $settings, $values ) {
	$selected = ( ! empty( $values[ $name ] ) ) ? 'checked' : '';
	?>
	<div class="stm_form_wrapper stm_form_wrapper_<?php echo esc_attr( $settings['type'] ); ?>  stm_form_wrapper_<?php echo esc_attr( $name ); ?> <?php echo esc_attr( stm_vehicles_listing_has_preview( $settings ) ); ?>" <?php stm_vehicles_listing_show_dependency( $settings ); ?>>
		<label>
			<input type="<?php echo esc_attr( $settings['type'] ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php echo esc_attr( $selected ); ?> />
			<span><?php echo esc_html( $settings['label'] ); ?></span>
		</label>
		<?php stm_vehicles_listings_preview( $settings ); ?>
	</div>
	<?php
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_divider to get the html of the divider field
 * @param $name
 *
 * @return void
 */
function stm_vehicle_listings_field_divider( $name ) {
	?>
	</div></div><div class="stm_listings_col_4 stm_<?php echo esc_attr( $name ); ?>"><div class="inner">
	<?php
}

/**
 * @used-by stm_vehicles_listings_show_field
 * @uses stm_vehicle_listings_field_icon to get the html of the icon field
 * @param $name
 * @param $settings
 * @param $values
 *
 * @return void
 */
function stm_vehicle_listings_field_icon( $name, $settings, $values ) {
	$icon  = ( ! empty( $values[ $name ] ) ) ? $values[ $name ] : '';
	$value = ( ! empty( $values[ $name ] ) ) ? $values[ $name ] : '';
	?>
	<div class="stm_form_wrapper stm_form_wrapper_<?php echo esc_attr( $settings['type'] ); ?>">
		<span><?php echo esc_html( $settings['label'] ); ?></span>
		<input type="hidden" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" />
		<div class="stm_vehicles_listing_icon">
			<div class="icon">
				<img src="<?php echo esc_url( STM_LISTINGS_URL . '/assets/images/plus.svg' ); ?>" alt="" class="stm-default-icon_<?php echo esc_attr( $value ); ?>" />
				<i class="<?php echo esc_attr( $icon ); ?>"></i>
			</div>
			<?php if ( empty( $value ) ) : ?>
				<div class="stm_change_icon"><?php esc_html_e( 'Add icon', 'motors_listing_types' ); ?></div>
			<?php else : ?>
				<div class="stm_change_icon"><?php esc_html_e( 'Change icon', 'motors_listing_types' ); ?></div>
			<?php endif; ?>
			<div class="stm_delete_icon"><?php esc_html_e( 'Delete icon', 'motors_listing_types' ); ?></div>
		</div>
	</div>
	<?php
}

function stm_vehicles_listings_preview( $settings ) {
	if ( ! empty( $settings['preview'] ) ) :
		$url = ( ! empty( $settings['preview_url'] ) ) ? $settings['preview_url'] : STM_LISTINGS_URL . '/assets/images/tmp/';
		?>
		<a href="#" data-image="<?php echo esc_url( $url . $settings['preview'] ); ?>">
			<?php esc_html_e( 'Preview', 'motors_listing_types' ); ?>
		</a>

		<?php
	endif;
}

function stm_vehicles_listing_show_dependency( $settings ) {
	$dependency = '';
	if ( ! empty( $settings['dependency'] ) ) {
		$setting    = $settings['dependency'];
		$dependency = 'data-depended="true" ';

		foreach ( $setting as $key => $value ) {

			if ( is_array( $value ) ) {
				foreach ( $value as $slug => $_value ) {
					$dependency .= 'data-' . $slug . '="' . esc_attr( $_value ) . '"';
				}
			} else {
				$dependency .= 'data-' . $key . '="' . esc_attr( $value ) . '"';
			}
		}
	}

	echo wp_kses_post( apply_filters( 'stm_vl_depends_filter', $dependency ) );
}
