<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $items
 * @var $show_amount
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // phpcs:ignore WordPress.PHP.DontExtract.extract_extract

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

if ( isset( $items ) && strlen( $items ) > 0 ) {
	$items = vc_param_group_parse_atts( $items );
	if ( ! is_array( $items ) ) {
		$temp         = explode( ',', $items );
		$param_values = array();
		foreach ( $temp as $value ) {
			$data                  = explode( '|', $value );
			$new_line              = array();
			$new_line['title']     = isset( $data[0] ) ? $data[0] : 0;
			$new_line['sub_title'] = isset( $data[1] ) ? $data[1] : '';
			if ( isset( $data[1] ) && preg_match( '/^\d{1,3}\%$/', $data[1] ) ) {
				$new_line['title']     = (float) str_replace( '%', '', $data[1] );
				$new_line['sub_title'] = isset( $data[2] ) ? $data[2] : '';
			}
			$param_values[] = $new_line;
		}
		$items = rawurlencode( wp_json_encode( $param_values ) );
	}
}

$multilisting = new STMMultiListing();

if ( empty( $show_amount ) ) {
	$show_amount = 'no';
}

$words = array();

if ( ! empty( $select_prefix ) ) {
	$words['select_prefix'] = $select_prefix;
}

if ( ! empty( $select_affix ) ) {
	$words['select_affix'] = $select_affix;
}

if ( ! empty( $number_prefix ) ) {
	$words['number_prefix'] = $number_prefix;
}

if ( ! empty( $number_affix ) ) {
	$words['number_affix'] = $number_affix;
}

$pt_tax_arr = array();

$listings_post_type = apply_filters( 'stm_listings_post_type', 'listings' );

?>
<div class="stm-c-f-search-form-wrap multilisting-search-tabs-wrap filter-listing stm-vc-ajax-filter animated fadeIn <?php echo esc_attr( $css_class ); ?>">

	<?php if ( is_array( $items ) && ! empty( $items ) ) : ?>
		<ul class="nav nav-tabs" role="tablist">

			<?php
			$i = 1;

			foreach ( $items as $key => $item ) :
				$stm_post_type = $item['tab_listing_type'];
				if ( ! empty( $stm_post_type ) ) :
					$stm_title = ( empty( $item['tab_title_single'] ) ) ? $multilisting->stm_get_listing_name_by_slug( $stm_post_type ) : $item['tab_title_single'];
					$slug      = ( isset( $item['tab_id_single'] ) ) ? sanitize_title( $item['tab_id_single'] ) : sanitize_title( $stm_title );

					if ( $listings_post_type === $stm_post_type && empty( $item['tab_title_single'] ) ) {
						$stm_title = esc_html__( 'Listings', 'motors_listing_types' );
					}

					$li_class   = 'nav-item';
					$link_class = 'nav-link stm-cursor-pointer heading-font';
					$_expanded  = 'false';

					if ( 1 === $i ) {
						$li_class  = $link_class .= ' active';
						$_expanded = 'true';
					}
					?>
					<li class="<?php echo esc_attr( $li_class ); ?>">
						<?php $icon = stm_multilisting_get_type_icon_by_slug( $stm_post_type ); ?>
						<a href="#<?php echo esc_attr( $stm_post_type ); ?>"
							class="<?php echo esc_attr( $link_class ); ?>"
							aria-expanded="<?php echo esc_attr( $_expanded ); ?>"
							aria-controls="<?php echo esc_attr( $stm_post_type ); ?>"
							role="tab"
							data-toggle="tab"
							data-slug="<?php echo esc_attr( $slug ); ?>"
							>
							<?php if ( ! empty( $icon ) ) : ?>
								<i class="<?php echo esc_attr( $icon ); ?>"></i>
							<?php endif; ?>
							<?php echo esc_attr( $stm_title ); ?>
						</a>
					</li>
				<?php endif; ?>
				<?php $i++; ?>
			<?php endforeach; ?>
		</ul>

		<div class="tab-content">
			<?php $i = 1; ?>
			<?php
			foreach ( $items as $key => $item ) :
				$stm_post_type                = $item['tab_listing_type'];
				$pt_tax_arr[ $stm_post_type ] = $stm_post_type;
				?>
				<?php
				if ( ! empty( $stm_post_type ) ) :
					$stm_title = ( empty( $item['tab_title_single'] ) ) ? $multilisting->stm_get_listing_name_by_slug( $stm_post_type ) : $item['tab_title_single'];
					$slug      = ( isset( $item['tab_id_single'] ) ) ? sanitize_title( $item['tab_id_single'] ) : sanitize_title( $stm_title );
					?>
					<div role="tabpanel" class="tab-pane fade
					<?php
					if ( 1 === $i ) {
						echo 'active in';}
					?>
					" id="<?php echo esc_attr( $stm_post_type ); ?>">
						<?php
						if ( ! empty( $item['taxonomy_tab'] ) ) {
							$tax_term       = explode( ',', $item['taxonomy_tab'] );
							$tax_term       = explode( ' | ', $tax_term[0] );
							$taxonomy_count = stm_get_custom_taxonomy_pt_count(
								$tax_term[0],
								$tax_term[1],
								$stm_post_type
							);
						} elseif ( ! empty( $item['filter_selected'] ) ) {
							$tax_term       = explode( ',', $item['filter_selected'] );
							$taxonomy_count = stm_get_custom_taxonomy_pt_count(
								'',
								$tax_term,
								$stm_post_type
							);
						} else {
							$taxonomy_count = stm_get_custom_taxonomy_pt_count(
								'',
								'',
								$stm_post_type
							);
						}
						?>

						<?php if ( isset( $item['filter_selected'] ) && ! empty( $item['filter_selected'] ) ) : ?>

							<form action="<?php echo esc_url( apply_filters( 'stm_inventory_page_url', '', $stm_post_type ) ); ?>" method="GET">
								<div class="row">
									<div class="col-md-10">
										<div class="stm-filter-tab-selects filter stm-vc-ajax-filter">
											<input type="hidden" name="posttype" value="<?php echo esc_attr( $stm_post_type ); ?>">
											<?php
												set_query_var( 'listings_type', $stm_post_type );
												HooksMultiListing::stm_listings_attributes_filter( array( 'slug' => $stm_post_type ) );

												apply_filters(
													'stm_listing_filter_get_selects',
													$item['filter_selected'],
													$slug,
													$words,
													$show_amount
												);
											?>
										</div>
									</div>
									<div class="col-md-2">
										<button type="submit" class="heading-font">
											<?php
											if ( empty( $search_button_label ) ) {
												$search_button_label = __( 'Search', 'motors_listing_types' );
											}

											echo esc_html( $search_button_label );
											?>
										</button>
									</div>
								</div>
							</form>

						<?php endif; ?>

					</div>

				<?php endif; ?>
				<?php $i++; ?>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>

	<?php wp_reset_postdata(); ?>
</div>

<?php
$bind_tax = array();
foreach ( $pt_tax_arr as $item ) {
	set_query_var( 'listings_type', $item );
	HooksMultiListing::stm_listings_attributes_filter( array( 'slug' => $item ) );
	$bind_tax = array_merge( $bind_tax, apply_filters( 'stm_data_binding_func', array(), true ) );
}


if ( ! empty( $bind_tax ) ) :
	?>

	<script>
		jQuery(function ($) {
			let options 	= Object.seal( <?php echo wp_json_encode( $bind_tax ); ?> ),
				show_amount = Boolean( <?php echo wp_json_encode( 'no' !== $show_amount ); ?> );

			if ( show_amount ) {
				for ( const item of Object.entries( options ) ) {
					if ( typeof item.options === "object" ) {
						for ( const option of Object.entries( item.options ) ) {
							option.label = option.label + ' (' + option.count + ')';
						}
					}
				}
			}

			$( '.stm-filter-tab-selects.filter' ).each(function () {
				new STMCascadingSelect( this, options );
			});

			$( 'select[data-class="stm_select_overflowed"]' ).on('change', function () {
				let min   = '',
					max   = '',
					$this = $(this),
					value = $this.val(),
					type  = $this.attr("data-sel-type");

				if( value === null || value.length === 0 ) return;

				if ( value.includes("<") ) {
					max = value.replace("<", "").trim();
				} else if ( value.includes("-") ) {
					let strSplit = value.split("-");

					min = strSplit.shift();
					max = strSplit.shift();
				} else {
					min = value.replace(">", "").trim();
				}

				$('input[name="min_' + type + '"]').val( min );
				$('input[name="max_' + type + '"]').val( max );
			});
		});
	</script>
	<?php
endif;

// reset everyting to original listings post type.
set_query_var( 'listings_type', $listings_post_type );
remove_all_filters( 'stm_listings_attributes' );
