<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\ContentControls\SelectControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;

use Motors_E_W\Pro\Widgets\WidgetBase;

class Gallery extends WidgetBase {

	use SwitcherControl, SelectControl, HeadingControl, SliderControl, ColorControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery', 'swiper', 'elementor-frontend' ) );
		if ( is_rtl() ) {
			$this->stm_ew_enqueue( self::get_name() . '-rtl', MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		}
	}

	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = self::get_name() . '-rtl';
		$widget_styles[] = 'swiper';

		return $widget_styles;
	}

	public function get_script_depends(): array {
		$depends   = parent::get_script_depends();
		$depends[] = 'swiper';

		return $depends;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-gallery';
	}

	public function get_title() {
		return esc_html__( 'Gallery', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-photo-gallery';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'Action buttons', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'use_slider',
			array(
				'label'   => esc_html__( 'Display Thumbnails', 'stm-elementor-widgets' ),
				'default' => 'yes',
			),
		);

		$this->stm_ew_add_heading(
			'actions_heading',
			array(
				'label' => esc_html__( 'Actions', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_switcher(
			'show_print',
			array(
				'label'   => esc_html__( 'Print', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_compare',
			array(
				'label'   => esc_html__( 'Compare', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_share',
			array(
				'label'   => esc_html__( 'Share', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		if ( boolval( apply_filters( 'is_listing', array() ) ) ) {
			$this->stm_ew_add_switcher(
				'show_featured',
				array(
					'label'   => esc_html__( 'Favorite', 'motors-elementor-widgets' ),
					'default' => '',
				)
			);
		}

		$this->stm_ew_add_switcher(
			'show_test_drive',
			array(
				'label'   => esc_html__( 'Test Drive', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_pdf',
			array(
				'label'   => esc_html__( 'PDF', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'section_styles', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_select(
			'badge_position',
			array(
				'label'       => esc_html__( 'Badge position', 'motors-elementor-widgets' ),
				'description' => esc_html__( '"Special", "Sold" etc.', 'motors-elementor-widgets' ),
				'options'     => array(
					'left-top'     => esc_html__( 'Left top', 'motors-elementor-widgets' ),
					'right-top'    => esc_html__( 'Right top', 'motors-elementor-widgets' ),
					'left-bottom'  => esc_html__( 'Left bottom', 'motors-elementor-widgets' ),
					'right-bottom' => esc_html__( 'Right bottom', 'motors-elementor-widgets' ),
				),
				'default'     => 'left-top',
			),
		);

		$this->stm_ew_add_heading(
			'onhover_heading',
			array(
				'label' => esc_html__( 'Onhover Effects', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_switcher(
			'show_actions_onhover',
			array(
				'label'       => esc_html__( 'Hide action buttons by default', 'motors-elementor-widgets' ),
				'description' => esc_html__( 'Show on hover', 'motors-elementor-widgets' ),
				'default'     => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_zoom_icon',
			array(
				'label'   => esc_html__( 'Show zoom icon', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_slider(
			'zoom_icon_size',
			array(
				'label'      => esc_html__( 'Icon Size', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px' => array(
						'min'  => 5,
						'max'  => 85,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 26,
				),
				'selectors'  => array(
					'{{WRAPPER}} .motors-elementor-single-listing-gallery .motors-elementor-big-gallery .stm-single-image a .image-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'show_zoom_icon' => 'yes',
				),
			),
		);

		$this->stm_ew_add_select(
			'zoom_icon_box_style',
			array(
				'label'     => esc_html__( 'Icon box style', 'motors-elementor-widgets' ),
				'options'   => array(
					'none'    => esc_html__( 'None', 'motors-elementor-widgets' ),
					'circle'  => esc_html__( 'Circle', 'motors-elementor-widgets' ),
					'hexagon' => esc_html__( 'Hexagon', 'motors-elementor-widgets' ),
				),
				'default'   => 'none',
				'condition' => array(
					'show_zoom_icon' => 'yes',
				),
			),
		);

		$this->stm_ew_add_color(
			'zoom_icon_box_color',
			array(
				'label'     => esc_html__( 'Icon box background color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .motors-elementor-single-listing-gallery .motors-elementor-big-gallery .stm-single-image a .image-icon'        => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .motors-elementor-single-listing-gallery .motors-elementor-big-gallery .stm-single-image a .image-icon:before' => 'border-bottom-color: {{VALUE}};',
					'{{WRAPPER}} .motors-elementor-single-listing-gallery .motors-elementor-big-gallery .stm-single-image a .image-icon:after'  => 'border-top-color: {{VALUE}};',
				),
				'condition' => array(
					'show_zoom_icon' => 'yes',
				),
			),
		);

		$this->stm_ew_add_switcher(
			'show_overlay',
			array(
				'label'   => esc_html__( 'Show overlay', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_slider(
			'overlay_opacity',
			array(
				'label'      => esc_html__( 'Overlay opacity (%)', 'motors-elementor-widgets' ),
				'size_units' => array( '%' ),
				'range'      => array(
					'%' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => '%',
					'size' => 40,
				),
				'selectors'  => array(
					'{{WRAPPER}} .motors-elementor-single-listing-gallery .motors-elementor-big-gallery .stm-single-image a .image-overlay' => 'background-color: rgba(10,10,10,.{{SIZE}});',
				),
				'condition'  => array(
					'show_overlay' => 'yes',
				),
			),
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'pro/widgets/single-listing/gallery', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
