<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\ContentControls\SelectControl;
use STM_E_W\Widgets\Controls\ContentControls\TextControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\Controls\StyleControls\DimensionsControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupBorderControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupBoxShadowControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupTypographyControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class TradeInButton extends WidgetBase {

	use TextControl;
	use IconsControl;
	use ColorControl;
	use DimensionsControl;
	use GroupBoxShadowControl;
	use HeadingControl;
	use GroupBorderControl;
	use SliderControl;
	use SelectControl;
	use GroupTypographyControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery' ) );

		$this->stm_ew_enqueue( 'sell-a-car-form' );
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-trade-in';
	}

	public function get_title() {
		return esc_html__( 'Trade In Button', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-cycle';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'tif_content', __( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_text(
			'tif_btn_label',
			array(
				'label'   => __( 'Label', 'motors-elementor-widgets' ),
				'default' => __( 'Trade In Form', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'tif_styles', __( 'Style', 'motors-elementor-widgets' ) );

		$this->stm_start_ctrl_tabs( 'tif_btn_bg_style' );

		$this->stm_start_ctrl_tab(
			'tif_bg_normal',
			array(
				'label' => __( 'Normal', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_color(
			'tif_btn_bg',
			array(
				'label'     => __( 'Background', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_icon_color',
			array(
				'label'     => __( 'Icon Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .stm-car_dealer-buttons a svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_text_color',
			array(
				'label'     => __( 'Text Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_border_color',
			array(
				'label'     => __( 'Border Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_group_box_shadow(
			'tif_box_shadow',
			array(
				'label'    => __( 'Box Shadow', 'motors-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .stm-car_dealer-buttons a',
			)
		);

		$this->stm_end_ctrl_tab();

		$this->stm_start_ctrl_tab(
			'tif_bg_hover',
			array(
				'label' => __( 'Hover', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_color(
			'tif_btn_bg_hover',
			array(
				'label'     => __( 'Background', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_icon_color_hover',
			array(
				'label'     => __( 'Icon Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a:hover i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .stm-car_dealer-buttons a:hover svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_text_color_hover',
			array(
				'label'     => __( 'Text Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'tif_border_color_hover',
			array(
				'label'     => __( 'Border Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a:hover' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->stm_ew_add_group_box_shadow(
			'tif_box_shadow_hover',
			array(
				'label'    => __( 'Box Shadow', 'motors-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .stm-car_dealer-buttons a:hover',
			)
		);

		$this->stm_end_ctrl_tab();

		$this->stm_end_ctrl_tabs();

		$this->stm_ew_add_heading(
			'tif_btn_bg_after',
			array(
				'separator' => 'after',
			)
		);

		$this->stm_ew_add_group_typography(
			'tif_typography',
			array(
				'label'     => __( 'Typography', 'motors-elementor-widgets' ),
				'separator' => 'before',
				'exclude'   => array(
					'font_family',
					'font_style',
					'text_decoration',
					'letter_spacing',
					'word_spacing',
				),
				'selector'  => '{{WRAPPER}} .stm-car_dealer-buttons a',
			)
		);

		$this->stm_ew_add_heading(
			'border_before',
			array(
				'separator' => 'before',
			)
		);

		$this->stm_ew_add_border(
			'tif_border',
			array(
				'label'    => __( 'Border', 'motors-elementor-widgets' ),
				'exclude'  => array( 'color' ),
				'selector' => '{{WRAPPER}} .stm-car_dealer-buttons a',
			)
		);

		$this->stm_ew_add_dimensions(
			'tif_btn_border_radius',
			array(
				'label'     => __( 'Border Radius', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => true,
				),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_heading(
			'border_after',
			array(
				'separator' => 'after',
			)
		);

		$this->stm_ew_add_dimensions(
			'tif_btn_padding',
			array(
				'label'     => __( 'Padding', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'      => '17',
					'right'    => '25',
					'bottom'   => '17',
					'left'     => '25',
					'isLinked' => false,
				),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_heading(
			'icon_styles',
			array(
				'label'     => __( 'Icon', 'motors-elementor-widgets' ),
				'separator' => 'before',
			)
		);

		$this->stm_ew_add_slider(
			'tif_icon_size',
			array(
				'label'      => __( 'Icon Size', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px' => array(
						'min'  => 8,
						'max'  => 40,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 16,
				),
				'selectors'  => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .stm-car_dealer-buttons a svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_select(
			'tif_icon_position',
			array(
				'label'     => __( 'Icon Position', 'motors-elementor-widgets' ),
				'options'   => array(
					'row-reverse' => __( 'Left', 'motors-elementor-widgets' ),
					'row'         => __( 'Right', 'motors-elementor-widgets' ),
				),
				'default'   => 'row',
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a' => 'flex-direction: {{VALUE}};',
				),
			),
		);

		$this->stm_ew_add_dimensions(
			'tif_icon_margin',
			array(
				'label'     => __( 'Icon Margin', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => true,
				),
				'selectors' => array(
					'{{WRAPPER}} .stm-car_dealer-buttons a i'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .stm-car_dealer-buttons a img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$is_edit = Helper::is_elementor_edit_mode();

		if ( ! $is_edit ) {
			wp_enqueue_script( 'sell-a-car-form' );
		}

		Helper::stm_ew_load_template( 'pro/widgets/single-listing/trade-in', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}

	public function motors_add_modal() {
		Helper::stm_ew_load_template( 'modals/trade-in-default', MOTORS_ELEMENTOR_WIDGETS_PATH, array() );
	}
}
