<?php

namespace STM_E_W\Widgets;

use STM_E_W\Helpers\Helper;
use STM_E_W\STMApp;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\ContentControls\TextAreaControl;
use STM_E_W\Widgets\Controls\ContentControls\TextControl;
use STM_E_W\Widgets\Controls\ContentControls\MediaControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupTypographyControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\WidgetBase;

class FlipBox extends WidgetBase {

	use TextControl;
	use TextAreaControl;
	use HeadingControl;
	use IconsControl;
	use MediaControl;
	use GroupTypographyControl;
	use ColorControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_enqueue( self::get_name() );
	}

	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();

		return $widget_styles;
	}

	public function get_name() {
		return STMApp::STM_PREFIX . '-flip-box';
	}

	public function get_title() {
		return esc_html__( 'Flip Box', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-icon-box';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'section_content', __( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_text(
			'flipbox_title',
			array(
				'label'   => __( 'Title', 'motors-elementor-widgets' ),
				'default' => __( 'Flip Box Title', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_textarea(
			'flipbox_description',
			array(
				'label'   => __( 'Description', 'motors-elementor-widgets' ),
				'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
			)
		);

		$this->stm_ew_add_icons(
			'flipbox_icon',
			array(
				'label'            => __( 'Icon', 'motors-elementor-widgets' ),
				'skin'             => 'inline',
				'fa4compatibility' => 'icon',
			)
		);

		$this->stm_ew_add_media(
			'flipbox_image',
			array(
				'label' => __( 'Image', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_end_control_section();

		/*Start style section*/
		$this->stm_start_style_controls_section( 'section_style', __( 'Styles', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_group_typography(
			'flipbox_heading_typography',
			array(
				'label'    => esc_html__( 'Title Typography', 'motors-elementor-widgets' ),
				'exclude'  => array(
					'font_style',
					'text_decoration',
					'word_spacing',
				),
				'selector' => '{{WRAPPER}} .info-wrap span .stm_flipbox div .inner .inner-flex .ib-title',
			),
		);

		$this->stm_ew_add_color(
			'flipbox_backface_bg_color',
			array(
				'label'     => esc_html__( 'Backface Background Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .info-wrap span .stm_flipbox .stm_flipbox__back' => 'background-color: {{VALUE}};',
				),
			),
		);

		$this->stm_end_control_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$settings['flipbox_icon'] = $this->stm_ew_get_rendered_icon( 'flipbox_icon', $settings );

		Helper::stm_ew_load_template( 'widgets/flip-box', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}

}
