<?php

namespace Motors_E_W\Widgets\Rental;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\WidgetBase;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;

class RentalReservationSteps extends WidgetBase {
	use HeadingControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );
		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( $this->get_name() );
	}
	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_RENTAL );
	}
	public function get_name() {
		return MotorsApp::STM_PREFIX . '-rental-reservation-steps';
	}

	public function get_title() {
		return esc_html__( 'Rental Reservation Steps', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-navigation-horizontal eicons-motors';
	}

	public function register_controls() {
		$this->stm_start_content_controls_section( 'general', __( 'General', 'motors-elementor-widgets' ) );
		$shop_page_id   = get_option( 'woocommerce_shop_page_id' );
		$shop_page_link = home_url() . '/wp-admin/post.php?post=' . $shop_page_id . '&action=edit';
		$this->stm_ew_add_heading(
			'reservation_steps_hint',
			array(
				'label' => 'To change background on reservation steps page, please go to  <a href="' . $shop_page_link . '" target="_blank">archive</a> page and set featured image.',
			)
		);

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'widgets/rental/rental-reservation-steps', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
