<?php
/****
 * @var $autoplay
 * @var $transition_speed
 * @var $delay
 * @var $pause_on_mouseover
 * @var $navigation
 * @var $stretch
 * @var $include_video
 * @var $slides_per_view
 * */

$slider_options = compact(
	'slides_per_view',
	'autoplay',
	'transition_speed',
	'delay',
	'pause_on_mouseover',
	'navigation',
);

global $listing_id;

$listing_id    = ( is_null( $listing_id ) ) ? get_the_ID() : $listing_id;
$uniqid        = uniqid();
$gallery       = get_post_meta( $listing_id, 'gallery', true );
$video_preview = get_post_meta( $listing_id, 'video_preview', true );
$gallery_video = get_post_meta( $listing_id, 'gallery_video', true );

?>

<div class="motors-elementor-single-listing-gallery-carousel-mini">

	<div class="listing-gallery-carousel-mini listing-gallery-carousel-mini-<?php echo esc_attr( $uniqid ); ?> swiper-container" data-options="<?php echo esc_attr( wp_json_encode( $slider_options ) ); ?>" data-widget-id="<?php echo esc_attr( $uniqid ); ?>">

		<div class="swiper-wrapper">

			<?php
			if ( has_post_thumbnail( $listing_id ) ) :
				$thumb_src = wp_get_attachment_image_src( get_post_thumbnail_id( $listing_id ), 'full' );
				if ( $thumb_src && is_array( $thumb_src ) ) :
					?>
					<div class="swiper-slide" data-id="big-image-<?php echo esc_attr( get_post_thumbnail_id( $listing_id ) ); ?>">
						<a href="<?php echo esc_url( $thumb_src[0] ); ?>" class="stm_fancybox" target="_blank" rel="stm-car-gallery-carousel">
							<?php echo get_the_post_thumbnail( $listing_id, 'stm-img-398-x-2', array( 'class' => 'img-responsive' ) ); ?>
						</a>
					</div>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ( ! empty( $gallery ) ) : ?>
				<?php foreach ( $gallery as $gallery_image ) : ?>
					<?php $src = wp_get_attachment_image_src( $gallery_image, 'stm-img-398-x-2' ); ?>
					<?php $full_src = wp_get_attachment_image_src( $gallery_image, 'full' ); ?>
					<?php if ( ! empty( $src[0] ) && get_post_thumbnail_id( $listing_id ) !== $gallery_image ) : ?>
						<div class="swiper-slide" data-id="big-image-<?php echo esc_attr( $gallery_image ); ?>">
							<a href="<?php echo esc_url( $full_src[0] ); ?>" class="stm_fancybox" target="_blank" rel="stm-car-gallery-carousel">
								<img src="<?php echo esc_url( $src[0] ); ?>" alt="
								<?php
								printf(
								/* translators: post title */
									esc_attr__( '%s full', 'motors-elementor-widgets' ),
									esc_html( get_the_title( $listing_id ) )
								);
								?>
									"
								/>
							</a>
						</div>
					<?php endif; ?>
				<?php endforeach; ?>
			<?php endif; ?>

		</div>

	</div>

	<?php if ( $navigation && ( ! empty( $gallery ) || ( isset( $thumb_src ) && $thumb_src ) ) ) : ?>
		<div class="listing-gallery-carousel-mini-nav listing-gallery-carousel-mini-nav-<?php echo esc_attr( $uniqid ); ?>">
			<div class="listing-gallery-carousel-mini-nav-prev"></div>
			<div class="listing-gallery-carousel-mini-nav-next"></div>
		</div>
	<?php endif; ?>

</div>
