<?php
/**
 * @var $wa_massage
 */

global $listing_id;

$listing_id = ( is_null( $listing_id ) ) ? get_the_ID() : $listing_id;

$listing_url   = get_the_permalink( $listing_id );
$listing_title = get_the_title( get_the_ID() );

$shortcodes = array(
	'{{listing_url}}'   => $listing_url,
	'{{listing_title}}' => $listing_title,
);

foreach ( $shortcodes as $shortcode => $value ) {
	if ( strpos( $wa_massage, $shortcode ) !== false ) {
		$wa_massage = str_replace( $shortcode, $value, $wa_massage );
	}
}


$listing_author_id = get_post_meta( $listing_id, 'stm_car_user', true );
if ( ! empty( $listing_author_id ) ) {
	$user_phone   = get_the_author_meta( 'stm_phone', $listing_author_id );
	$has_whatsapp = get_the_author_meta( 'stm_whatsapp_number', $listing_author_id );

	if ( ! empty( $user_phone ) && ! empty( $has_whatsapp ) ) {
		$phone_number = $user_phone;
	}
}

if ( empty( $phone_number ) ) {
	$blogusers = get_users( array( 'role__in' => array( 'administrator' ) ) );

	if ( ! empty( $blogusers ) ) {
		foreach ( $blogusers as $user ) {
			$phone = get_the_author_meta( 'stm_phone', $user->ID );
			if ( ! empty( $phone ) && empty( $phone_number ) ) {
				$phone_number = $phone;
			}
		}
	}
}

$is_elementor_editor = \Elementor\Plugin::$instance->editor->is_edit_mode();
if ( $is_elementor_editor ) {
	$phone_number = '+111 111 11 11';
	$has_whatsapp = 'on';
}

?>
<div class="whats-button-wrap">
	<?php if ( ! empty( $phone_number ) && ! empty( $has_whatsapp ) ) : ?>
		<div class="whatsapp">
			<a href="https://wa.me/<?php echo esc_attr( trim( preg_replace( '/[^0-9]/', '', $phone_number ) ) ); ?>?text=<?php echo rawurlencode( $wa_massage ); ?>" target="_blank">
				<div class="whatsapp-btn heading-font">
					<?php echo wp_kses( $wa_icon, apply_filters( 'stm_ew_kses_svg', array() ) ); ?>
					<?php echo esc_html( $wa_label ); ?>
				</div>
			</a>
		</div>
	<?php endif; ?>
</div>

<style>

	.whats-button-wrap .whatsapp .whatsapp-btn {
		display: flex;
		align-items: center;
		text-align: left;
	}

	.whats-button-wrap a,
	.whats-button-wrap a:hover,
	.whats-button-wrap a:focus,
	.whats-button-wrap a:active {
		text-decoration: none;
	}

</style>
