<?php

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Methods related to Settings
 *
 * @class RP_SUB_Settings
 * @package Subscriptio
 * @author RightPress
 */

class RP_SUB_Settings extends RightPress_Plugin_Settings
{

    // Singleton control
    protected static $instance = false; public static function get_instance() { return self::$instance ? self::$instance : (self::$instance = new self()); }

    // Define settings structure version
    protected $version = '1';

    // Define parent menu key
    protected $parent_menu_key = 'edit.php?post_type=rp_sub_subscription';

    // Tab key for import and export section
    protected $import_export_tab_key = 'advanced';

    /**
     * Constructor
     *
     * @access public
     * @return void
     */
    public function __construct()
    {

        // Call parent constructor
        parent::__construct();
    }

    /**
     * Define structure
     *
     * @access public
     * @return array
     */
    public function define_structure()
    {
		global $rpsub_string;

        return array(

            /**
             * GENERAL
             */
            'general' => array(
                'title'     => $rpsub_string['general'],
                'children'  => array(

                    /**
                     * GENERAL SETTINGS
                     */
                    'general_settings' => array(
                        'title'     => $rpsub_string['general'],
                        'children'  => array(

                            'add_to_cart_label' => array(
                                'type'          => 'text',
                                'title'         => $rpsub_string['add_to_cart_label_title'],
                                'placeholder'   => $rpsub_string['add_to_cart_label_plchdrl'],
                                'hint'          => $rpsub_string['add_to_cart_label_hint'],
                            ),

                            'multiple_product_checkout' => array(
                                'type'          => 'select',
                                'title'         => $rpsub_string['multiple_product_checkout_title'],
                                'hint'          => $rpsub_string['multiple_product_checkout_hint'],
                                'options'       => array(
                                    'multiple_subscriptions'    => $rpsub_string['multiple_subscriptions'],
                                    'single_subscription'       => $rpsub_string['single_subscription'],
                                ),
                                'default'       => 'multiple_subscriptions',
                                'validation'    => array('is_required' => true),
                            ),
                        ),
                    ),

                    /**
                     * MY ACCOUNT
                     */
                    'my_account' => array(
                        'title'     => $rpsub_string['my_account_title'],
                        'children'  => array(

                            'display_empty_subscription_list' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['display_empty_subscription_list_title'],
                                'default'   => '1',
                            ),
                        ),
                    ),

                    /**
                     * PRICING
                     */
                    'pricing' => array(
                        'title'     => $rpsub_string['pricing_title'],
                        'children'  => array(

                            'sale_price_is_recurring' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['sale_price_is_recurring_title'],
                                'default'   => '1',
                            ),

                            'cart_discounts_are_recurring' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['cart_discounts_are_recurring_title'],
                                'default'   => '0',
                            ),

                            'checkout_fees_are_recurring' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['checkout_fees_are_recurring_title'],
                                'default'   => '0',
                            ),

                            'shipping_is_recurring' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['shipping_is_recurring_title'],
                                'default'   => '1',
                            ),

                            'signup_fees_per_item' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['signup_fees_per_item_title'],
                                'default'   => '0',
                            ),
                        ),
                    ),

                    /**
                     * REFUNDS
                     */
                    'refunds' => array(
                        'title'     => $rpsub_string['refunds_title'],
                        'children'  => array(

                            'cancel_on_refunded_payment' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['cancel_on_refunded_payment_title'],
                                'default'   => '0',
                            ),
                        ),
                    ),
                ),
            ),

            /**
             * LIMITS
             */
            'limits' => array(
                'title'     => $rpsub_string['limits_title'],
                'children'  => array(

                    /**
                     * SUBSCRIPTION LIMITS
                     */
                    'subscription_limits' => array(
                        'title' => $rpsub_string['subscription_limits_title'],
                        'children' => array(

                            'subscription_limit' => array(
                                'type'          => 'select',
                                'title'         => $rpsub_string['subscription_limit_title'],
                                'options'       => array(
                                    'no_limit'          => $rpsub_string['subscription_limit_no_limit'],
                                    'one_per_product'   => $rpsub_string['subscription_limit_one_per_product'],
                                    'one_per_customer'  => $rpsub_string['subscription_limit_one_per_customer'],
                                ),
                                'default'       => 'no_limit',
                                'validation'    => array('is_required' => true),
                            ),

                            'trial_limit' => array(
                                'type'          => 'select',
                                'title'         => $rpsub_string['trial_limit_title'],
                                'options'       => array(
                                    'no_limit'          => $rpsub_string['trial_limit_no_limit'],
                                    'one_per_product'   => $rpsub_string['trial_limit_one_per_product'],
                                    'one_per_customer'  => $rpsub_string['trial_limit_one_per_customer'],
                                ),
                                'default'       => 'no_limit',
                                'validation'    => array('is_required' => true),
                            ),
                        ),
                    ),

                    /**
                     * CUSTOMER CAPABILITIES
                     */
                    'customer_capabilities' => array(
                        'title'     => $rpsub_string['customer_capabilities_title'],
                        'children'  => array(

                            'customer_pausing' => array(
                                'type'          => 'select',
                                'title'         => $rpsub_string['customer_pausing_title'],
                                'options'       => array(
                                    'not_allowed'           => $rpsub_string['customer_pausing_not_allowed'],
                                    'allowed_no_limits'     => $rpsub_string['customer_pausing_allowed_no_limits'],
                                    'allowed_with_limits'   => $rpsub_string['customer_pausing_allowed_with_limits'],
                                ),
                                'default'       => 'not_allowed',
                                'validation'    => array('is_required' => true),
                            ),

                            'customer_pausing_number_limit' => array(
                                'type'          => 'number',
                                'title'         => $rpsub_string['customer_pausing_number_limit_title'],
                                'after'         => $rpsub_string['customer_pausing_number_limit_after'],
                                'validation'    => array(
                                    'is_whole'  => true,
                                    'min'       => 1,
                                ),
                                'placeholder'   => $rpsub_string['customer_pausing_number_limit_plchldr'],
                                'conditions'    => array(
                                    'customer_pausing' => array(
                                        'value' => 'allowed_with_limits',
                                    ),
                                ),
                            ),

                            'customer_pausing_duration_limit' => array(
                                'type'          => 'number',
                                'title'         => $rpsub_string['customer_pausing_duration_limit_title'],
                                'after'         => $rpsub_string['customer_pausing_duration_limit_after'],
                                'validation'    => array(
                                    'is_whole'  => true,
                                    'min'       => 1,
                                ),
                                'placeholder'   => $rpsub_string['customer_pausing_duration_limit_plchldr'],
                                'conditions'    => array(
                                    'customer_pausing' => array(
                                        'value' => 'allowed_with_limits',
                                    ),
                                ),
                            ),

                            'customer_cancelling' => array(
                                'type'          => 'select',
                                'title'         => $rpsub_string['customer_cancelling_title'],
                                'options'       => array(
                                    'not_allowed'   => $rpsub_string['customer_cancelling_not_allowed'],
                                    'delayed'       => $rpsub_string['customer_cancelling_delayed'],
                                    'immediate'     => $rpsub_string['customer_cancelling_immediate'],
                                ),
                                'default'       => 'not_allowed',
                                'validation'    => array('is_required' => true),
                            ),
                        ),
                    ),
                ),
            ),

            /**
             * SCHEDULE
             */
            'schedule' => array(
                'title'     => $rpsub_string['schedule_title'],
                'children'  => array(

                    /**
                     * AUTOMATIC PAYMENTS
                     */
                    'automatic_payment_schedule' => array(
                        'title'     => $rpsub_string['automatic_payment_schedule_title'],
						'info'      => $rpsub_string['automatic_payment_schedule_info'],
                        'children'  => array(

                            'payment_retries' => array(
                                'type'          => 'tags',
                                'title'         => $rpsub_string['payment_retries_title'],
                                'placeholder'   => $rpsub_string['payment_retries_plchldr'],
                                'after'         => $rpsub_string['payment_retries_after'],
                                'default'       => '',
                            ),
                        ),
                    ),

                    /**
                     * MANUAL PAYMENTS
                     */
                    'manual_payment_schedule' => array(
                        'title'     => $rpsub_string['manual_payment_schedule_title'],
                        'info'      => $rpsub_string['manual_payment_schedule_info'],
                        'children'  => array(

                            'renewal_order_offset' => array(
                                'type'          => 'number',
                                'title'         => $rpsub_string['renewal_order_offset_title'],
                                'placeholder'   => $rpsub_string['renewal_order_offset_plchldr'],
                                'after'         => $rpsub_string['renewal_order_offset_after'],
                                'default'       => 1,
                                'validation'    => array(
                                    'is_required'   => true,
                                    'is_whole'      => true,
                                    'min'           => 1,
                                ),
                            ),

                            'payment_reminders' => array(
                                'type'          => 'tags',
                                'title'         => $rpsub_string['payment_reminders_title'],
                                'placeholder'   => $rpsub_string['payment_reminders_plchldr'],
                                'after'         => $rpsub_string['payment_reminders_after'],
                                'default'       => '',
                                'conditions'    => array(
                                    'renewal_order_offset' => array(
                                        'not_empty' => true,
                                    ),
                                ),
                            ),

                            'overdue_period' => array(
                                'type'          => 'number',
                                'title'         => $rpsub_string['overdue_period_title'],
                                'placeholder'   => $rpsub_string['overdue_period_plchldr'],
                                'after'         => $rpsub_string['overdue_period_after'],
                                'default'       => '',
                                'validation'    => array(
                                    'is_whole'  => true,
                                    'min'       => 1,
                                ),
                            ),

                            'overdue_payment_reminders' => array(
                                'type'          => 'tags',
                                'title'         => $rpsub_string['overdue_payment_reminders_title'],
                                'placeholder'   => $rpsub_string['overdue_payment_reminders_plchldr'],
                                'after'         => $rpsub_string['overdue_payment_reminders_after'],
                                'default'       => '',
                                'conditions'    => array(
                                    'overdue_period' => array(
                                        'not_empty' => true,
                                    ),
                                ),
                            ),
                        ),
                    ),

                    /**
                     * Suspensions
                     */
                    'suspensions' => array(
                        'title'     => $rpsub_string['suspensions_title'],
                        'info'      => $rpsub_string['suspensions_info'],
                        'children'  => array(

                            'suspension_period' => array(
                                'type'          => 'number',
                                'title'         => $rpsub_string['suspension_period_title'],
                                'placeholder'   => $rpsub_string['suspension_period_plchldr'],
                                'after'         => $rpsub_string['suspension_period_after'],
                                'default'       => '',
                                'validation'    => array(
                                    'is_whole'  => true,
                                    'min'       => 1,
                                ),
                            ),

                            'suspend_payment_reminders' => array(
                                'type'          => 'tags',
                                'title'         => $rpsub_string['suspend_payment_reminders_title'],
                                'placeholder'   => $rpsub_string['suspend_payment_reminders_plchldr'],
                                'after'         => $rpsub_string['suspend_payment_reminders_after'],
                                'default'       => '',
                                'conditions'    => array(
                                    'suspension_period' => array(
                                        'not_empty' => true,
                                    ),
                                ),
                            ),
                        ),
                    ),

                    /**
                     * PREPAID TERM EXTENSION
                     */
                    'prepaid_term_extension' => array(
                        'title'     => $rpsub_string['prepaid_term_extension_title'],
                        'info'      => $rpsub_string['prepaid_term_extension_info'],
                        'children'  => array(

                            'add_paused_days' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['add_paused_days_title'],
                                'default'   => '1',
                            ),

                            'add_suspended_days' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['add_suspended_days_title'],
                                'default'   => '0',
                            ),
                        ),
                    ),
                ),
            ),

            /**
             * PAYMENTS
             */
            'payments' => array(
                'title'     => $rpsub_string['payments_title'],
                'children'  => array(

                    /**
                     * STRIPE
                     */
                    'stripe' => array(
                        'title'         => $rpsub_string['stripe_title'],
                        'print_empty'   => true,
                        'children'      => array(

                        ),
                    ),

                    /**
                     * PAYPAL EXPRESS CHECKOUT
                     */
                    'paypal_ec' => array(
                        'title'         => $rpsub_string['paypal_ec_title'],
                        'print_empty'   => true,
                        'children'      => array(

                            'paypal_ec_enabled' => array(
                                'type'      => 'checkbox',
                                'title'     => $rpsub_string['paypal_ec_enabled_title'],
                                'default'   => '0',
                            ),
                        ),
                    ),

                    /**
                     * MANUAL PAYMENTS
                     */
                    'manual_payments' => array(
                        'title'         => $rpsub_string['manual_payments_title'],
                        'print_empty'   => true,
                        'children'      => array(

                        ),
                    ),
                ),
            ),

            /**
             * ADVANCED
             */
            'advanced' => array(
                'title'     => $rpsub_string['advanced_title'],
                'children'  => array(

                ),
            ),
        );
    }

    /**
     * Migrate settings
     *
     * @access public
     * @param array $stored
     * @return array
     */
    public function migrate_settings($stored)
    {

        return RP_SUB_Data_Updater::migrate_settings($stored, $this->version);
    }

    /**
     * Get plugin private prefix
     *
     * @access public
     * @return string
     */
    public function get_plugin_private_prefix()
    {

        return RP_SUB_PLUGIN_PRIVATE_PREFIX;
    }

    /**
     * Get plugin path
     *
     * @access public
     * @return string
     */
    public function get_plugin_path()
    {

        return RP_SUB_PLUGIN_PATH;
    }

    /**
     * Get settings capability
     *
     * @access public
     * @return string
     */
    public function get_capability()
    {

        return RP_SUB::get_admin_capability();
    }

    /**
     * Custom sanitization handler
     *
     * Boolean false return value is reserved to indicate that value was not sanitized
     *
     * @access protected
     * @param array $input
     * @param string $field_key
     * @param string $prefixed_key
     * @param mixed $current_value
     * @param array $output
     * @param array $field
     * @return mixed
     */
    protected function sanitize_custom($input, $field_key, $prefixed_key, $current_value, $output, $field)
    {

        // Sanitize payment retries and reminders
        if (in_array($field_key, array('payment_retries', 'payment_reminders', 'overdue_payment_reminders', 'suspend_payment_reminders'), true)) {

            // Call main tags sanitizer
            $output = $this->sanitize_field_tags($input, $prefixed_key, $current_value, $field);

            // Leave only positive whole integers as ints
            foreach ($output as $key => $value) {

                // TODO: We should prevent entering wrong values in UI in the first place

                // Value must be positive whole number
                if (!RightPress_Help::is_whole_number($value) || $value < 1) {
                    unset($output[$key]);
                }
                // Cast value to int
                else {
                    $output[$key] = (int) $value;
                }
            }

            // Sort numeric values
            if ($field_key === 'payment_retries') {
                asort($output);
            }
            else {
                arsort($output);
            }

            // Return sanitized value
            return $output;
        }

        // Value was not sanitized
        return false;
    }

    /**
     * Print section info
     *
     * @access public
     * @param array $section
     * @return void
     */
    public function print_section_info($section)
    {

        // Gateways - Stripe
        if ($section['id'] === 'stripe') {

            echo '<p>' . sprintf(esc_html__('Subscriptio integrates with the official %s extension.', 'subscriptio'), ('<a href="http://url.rightpress.net/woocommerce-gateway-stripe-download-page">' . esc_html__('WooCommerce Stripe Payment Gateway', 'subscriptio') . '</a>')) . ' ' . sprintf(esc_html__('You can %s and install this payment gateway extension for free.', 'subscriptio'), ('<a href="http://url.rightpress.net/woocommerce-gateway-stripe-download-page">' . esc_html__('download', 'subscriptio') . '</a>')) . '</p>';
            echo '<p style="padding-top: 0;">' . esc_html__('If customer uses this payment method during checkout, subsequent subscription payments will be processed automatically.', 'subscriptio') . '</p>';
            echo '<p style="padding-top: 0;">' . sprintf(esc_html__('To learn more about this payment gateway extension, %s.', 'subscriptio'), ('<a href="http://url.rightpress.net/subscriptio-gateways-stripe">' . esc_html__('click here', 'subscriptio') . '</a>')) . '</p>';

            echo '<table class="form-table" role="presentation"><tbody><tr><th scope="row">' . esc_html__('Installed and enabled?', 'subscriptio') . '</th><td><span style="text-decoration: underline; text-decoration-style: dotted;">' . (RP_SUB_WooCommerce_Gateway_Stripe::get_payment_gateway() ? esc_html__('Yes', 'subscriptio') : esc_html__('No', 'subscriptio')) . '</span></td></tr></tbody></table>';
        }
        // Gateways - PayPal Express Checkout
        else if ($section['id'] === 'paypal_ec') {

            echo '<p>' . esc_html__('PayPal Express Checkout payment gateway extension comes bundled with Subscriptio. Reference Transactions must be enabled on your PayPal account for automatic payments to work.', 'subscriptio') . '</p>';
            echo '<p style="padding-top: 0;">' . sprintf(esc_html__('To learn more about this payment gateway extension, %s.', 'subscriptio'), ('<a href="http://url.rightpress.net/subscriptio-gateways-paypal-express-checkout">' . esc_html__('click here', 'subscriptio') . '</a>')) . '</p>';
        }
        // Gateways - Manual Payments
        else if ($section['id'] === 'manual_payments') {

            echo '<p>' . esc_html__('If automatic payments are not set up for a subscription, it will require manual payment at the beginning of each billing cycle. In this case customer will receive a payment due notification with a link to the renewal order payment page.', 'subscriptio') . '</p>';
            echo '<p style="padding-top: 0;">' . esc_html__('Any WooCommerce payment gateway extension can be used for manual subscription payments, including offline payment methods.', 'subscriptio') . '</p>';
            echo '<p style="padding-top: 0; margin-bottom: 25px;">' . sprintf(esc_html__('To learn more about manual subscription payments, %s.', 'subscriptio'), ('<a href="http://url.rightpress.net/subscriptio-gateways-manual-payments">' . esc_html__('click here', 'subscriptio') . '</a>')) . '</p>';
        }

        // Call parent
        parent::print_section_info($section);
    }





}

RP_SUB_Settings::get_instance();
